% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_factory.R
\name{create_kernel_functions}
\alias{create_kernel_functions}
\title{Create kernel functions based on configuration}
\usage{
create_kernel_functions(
  kernel.fun = "Schennach2004",
  if_approx_kernel = TRUE,
  kernel.resol = 1000,
  X = NULL,
  h = 0.09
)
}
\arguments{
\item{kernel.fun}{A string specifying the kernel function to be used.}

\item{if_approx_kernel}{Logical. If TRUE, uses approximations for the kernel function.}

\item{kernel.resol}{The resolution for kernel function approximation.}

\item{X}{Optional data vector used to determine approximation range.}

\item{h}{Optional bandwidth parameter used for approximation range.}
}
\value{
A list containing kernel function and its Fourier transform
}
\description{
Create kernel functions based on configuration
}
