% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbt.R
\name{nbt}
\alias{nbt}
\alias{nbt_end}
\alias{nbt_byte}
\alias{nbt_short}
\alias{nbt_int}
\alias{nbt_long}
\alias{nbt_float}
\alias{nbt_double}
\alias{nbt_string}
\alias{nbt_byte_array}
\alias{nbt_int_array}
\alias{nbt_long_array}
\alias{nbt_compound}
\alias{nbt_list}
\alias{is_nbt}
\alias{unnbt}
\alias{payload}
\alias{payload<-}
\title{Create an NBT value}
\usage{
nbt(x = list(), tag = 0L)

nbt_end()

nbt_byte(x = 0L)

nbt_short(x = 0L)

nbt_int(x = 0L)

nbt_long(x = 0L)

nbt_float(x = 0)

nbt_double(x = 0)

nbt_string(x = "")

nbt_byte_array(x = integer())

nbt_int_array(x = integer())

nbt_long_array(x = bit64::integer64())

nbt_compound(...)

nbt_list(...)

is_nbt(x)

unnbt(x)

payload(object)

payload(object) <- value
}
\arguments{
\item{x}{An nbt payload.}

\item{tag}{The tag of the data.}

\item{...}{Arguments to collect into an NBT compound or NBT list value.
Supports dynamic dots via \code{rlang::list2()}.}

\item{object}{An nbt value}

\item{value}{A new payload}
}
\description{
The Named Binary Tag (NBT) format is used by Minecraft for various data
types. An NBT value holds a 'payload' of data and a 'tag' indicating the type
of data held.

\code{nbt()} creates an nbt value. \verb{nbt_*()} family of functions are wrappers
around \code{nbt()} to create specific tags. \code{unnbt()} recursively strips NBT
metadata from an NBT value.

\code{payload()} and \verb{payload<-()} read and write an nbt value's payload.
}
