% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_model.R
\name{remove_lines}
\alias{remove_lines}
\alias{remove_lines.bi_model}
\title{Remove line(s) and/or block(s) in a libbi model}
\usage{
\method{remove_lines}{bi_model}(
  x,
  what,
  only,
  type = c("all", "assignment", "sample"),
  preserve_shell = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{\link{bi_model}} object}

\item{what}{either a vector of line number(s) to remove, or a vector of blocks to remove (e.g., "parameter")}

\item{only}{only remove lines assigning given names (as a vector of character strings)}

\item{type}{which types of lines to remove, either "all", "sample" (i.e., lines with a "~") or "assignment" (lines with a "<-" or "=") (default: "all")}

\item{preserve_shell}{if TRUE (default: FALSE), preserve the definition of a block even if all lines are removed; this is useful to preserve options passed to a \code{transition} or \code{ode} block}

\item{...}{ignored}
}
\value{
the updated \code{bi_model} object
}
\description{
Removes one or more lines in a libbi model.
}
\examples{
model_file_name <- system.file(package="rbi", "PZ.bi")
PZ <- bi_model(filename = model_file_name)
PZ <- remove_lines(PZ, 2)
}
\seealso{
\code{\link{bi_model}}
}
