% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{rba_panther_info}
\alias{rba_panther_info}
\title{Get PANTHER database Information}
\usage{
rba_panther_info(what, organism_chr_loc = FALSE, families_page = 1, ...)
}
\arguments{
\item{what}{what information to retrieve? should be one of: \itemize{
\item "organisms": Retrieve supported organisms in PANTHER.
\item "datasets": Retrieve available annotation datasets.
\item "families" Retrieve available family IDs.
\item "pathways" Retrieve available pathway IDs.}}

\item{organism_chr_loc}{(Logical) (only when 'what = "organisms"')
If TRUE, only organisms with chromosome location will be returned.
If FALSE (default) every organisms will be returned.}

\item{families_page}{(Numeric) (only when 'what = "families"')
Family information is very long, so results are paginated. Use this
argument to define the page to retrieve.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
For families, a list and otherwise a data frame with pertinent
  information.
}
\description{
Using this function you can retrieve a list of available organisms,
  annotation datasets, families, and pathways which are supported in
  PANTHER.
}
\section{Corresponding API Resources}{

 "GET http://www.pantherdb.org/services/oai/pantherdb/supportedgenomes"
 \cr "GET http://www.pantherdb.org/services/oai/pantherdb/supportedannotdatasets"
 \cr "GET http://www.pantherdb.org/services/oai/pantherdb/supportedpantherfamilies"
 \cr "GET http://www.pantherdb.org/services/oai/pantherdb/supportedpantherpathways"
}

\examples{
\donttest{
rba_panther_info(what = "organisms")
}
\donttest{
rba_panther_info(what = "families", families_page = 4)
}

}
\references{
\itemize{
  \item Mi, H., Muruganujan, A., Ebert, D., Huang, X., & Thomas, P. D.
  (2019). PANTHER version 14: more genomes, a new PANTHER GO-slim and
  improvements in enrichment analysis tools. Nucleic acids research, 47(D1),
  D419-D426.
  \item Mi, H., Muruganujan, A., Huang, X., Ebert, D., Mills, C., Guo, X.,
  & Thomas, P. D. (2019). Protocol Update for large-scale genome and gene
  function analysis with the PANTHER classification system (v. 14.0).
  Nature protocols, 14(3), 703-721.
  \item \href{http://www.pantherdb.org/services/details.jsp}{PANTHER
  Services Details}
  }
}
\seealso{
Other "PANTHER": 
\code{\link{rba_panther_enrich}()},
\code{\link{rba_panther_family}()},
\code{\link{rba_panther_homolog}()},
\code{\link{rba_panther_mapping}()},
\code{\link{rba_panther_ortholog}()},
\code{\link{rba_panther_tree_grafter}()}
}
\concept{"PANTHER"}
