% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_uniparc.R
\name{rba_uniprot_uniparc}
\alias{rba_uniprot_uniparc}
\title{Get UniParc entry}
\usage{
rba_uniprot_uniparc(
  upi = NULL,
  accession = NULL,
  db_id = NULL,
  upid = NULL,
  rf_dd_type = NULL,
  rf_db_id = NULL,
  rf_active = NULL,
  rf_tax_id = NULL,
  ...
)
}
\arguments{
\item{upi}{unique UniParc Identifier.}

\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}.}

\item{db_id}{Protein ID in the cross-reference (external) database.}

\item{upid}{\href{https://www.uniprot.org/help/proteome_id}{UniProt Proteome
identifier (UPID)}. You can supply up to 100 UPIDs.}

\item{rf_dd_type}{Filter the content of the UniParc entry by
\href{https://www.uniprot.org/database/}{cross-reference} names. You can
supply multiple values.}

\item{rf_db_id}{Filter the content of the UniParc entry by protein
identifiers in any cross-reference database. You can supply multiple
values.}

\item{rf_active}{(logical ) Filter the content of UniParc entry based on
active status on source database:\itemize{
\item NULL: (default) don't filter contents based on active status.
\item TRUE: only return contents which are still active.
\item FALSE: Only return contents which are not active.}}

\item{rf_tax_id}{(Numeric) Filter the content of the UniParc entry by
NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}. You can
supply multiple values.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list which correspond to a UniParc entry.
}
\description{
Use this function to retrieve UniParc entries. You can use either -and only
  one of- UniProt accession, Cross-reference database id, UniParc ID or
  UniProt Proteome UPID. You can also filter the returned content of
  the returned UniParc entry. see "Argument" section for more details.
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/uniparc/accession/{accession} "
 \cr "GET https://ebi.ac.uk/proteins/api/uniparc/dbreference/{dbid}"
 \cr "GET https://ebi.ac.uk/proteins/api/uniparc/proteome/{upid}"
 \cr "GET https://ebi.ac.uk/proteins/api/uniparc/upi/{upi}"
}

\examples{
\donttest{
rba_uniprot_uniparc(upi = "UPI00000000C9")
}
\donttest{
rba_uniprot_uniparc(upi = "UPI00000000C9")
}
\donttest{
rba_uniprot_uniparc(upi = "UPI00000000C9", rf_active = FALSE)
}

}
\references{
\itemize{
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  }
}
\seealso{
Other "UniProt - UniParc": 
\code{\link{rba_uniprot_uniparc_bestguess}()},
\code{\link{rba_uniprot_uniparc_search}()},
\code{\link{rba_uniprot_uniparc_sequence}()}
}
\concept{"UniProt - UniParc"}
