% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_antigens}
\alias{rba_uniprot_antigens}
\title{Get Antigens by UniProt Accession}
\usage{
rba_uniprot_antigens(accession, ...)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s).}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing the Antigenic features of your supplied
  UniProt protein's sequence.
}
\description{
UniProt maps Antigenic features from different sources to the proteins'
  sequences. Using this function, you can retrieve all the Antigenic
  features that has been map to a given UniProt protein's sequence.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/antigen/\{accession\}"
}

\examples{
\donttest{
rba_uniprot_antigens("P04626")
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Antigen": 
\code{\link{rba_uniprot_antigens_search}()}
}
\concept{"UniProt - Antigen"}
