% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{transpose_results}
\alias{transpose_results}
\title{Transpose results object}
\usage{
transpose_results(results, components)
}
\arguments{
\item{results}{A list of results.}

\item{components}{a character vector of components to extract
(i.e. \verb{"est", "se"}).}
}
\description{
Transposes a Results object (as created by \code{\link[=analyse]{analyse()}}) in order to group
the same estimates together into vectors.
}
\details{
Essentially this function takes an object of the format:\preformatted{x <- list(
    list(
        "trt1" = list(
            est = 1,
            se  = 2
        ),
        "trt2" = list(
            est = 3,
            se  = 4
        )
    ),
    list(
        "trt1" = list(
            est = 5,
            se  = 6
        ),
        "trt2" = list(
            est = 7,
            se  = 8
        )
    )
)
}

and produces:\preformatted{list(
    trt1 = list(
        est = c(1,5),
        se = c(2,6)
    ),
    trt2 = list(
        est = c(3,7),
        se = c(4,8)
    )
)
}
}
