% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_legend.R
\name{theme_legend}
\alias{theme_legend}
\title{Override theme parameters for legend attributes}
\usage{
theme_legend(
  fig,
  background_fill_alpha = 0.95,
  background_fill_color = "#fff",
  border_line_alpha = 0.5,
  border_line_cap = "butt",
  border_line_color = "black",
  border_line_dash = NULL,
  border_line_dash_offset = 0,
  border_line_join = "miter",
  border_line_width = 1,
  glyph_height = 20,
  glyph_width = 20,
  label_height = 20,
  label_standoff = 15,
  label_text_align = "left",
  label_text_alpha = 1,
  label_text_baseline = "bottom",
  label_text_color = "#444444",
  label_text_font = "Helvetica",
  label_text_font_size = "12pt",
  label_text_font_style = "normal",
  label_width = 50,
  legend_padding = 10,
  legend_spacing = 3,
  pars = NULL
)
}
\arguments{
\item{fig}{figure to modify}

\item{background_fill_alpha}{(numeric) background color alpha of plot}

\item{background_fill_color}{(color) background color of plot}

\item{border_line_alpha}{The line alpha for the legend border outline.}

\item{border_line_cap}{('butt', 'round', 'square') The line cap for the legend border outline.}

\item{border_line_color}{The line color for the legend border outline.}

\item{border_line_dash}{The line dash for the legend border outline.}

\item{border_line_dash_offset}{The line dash offset for the legend border outline.}

\item{border_line_join}{('miter', 'round', 'bevel') The line join for the legend border outline.}

\item{border_line_width}{The line width for the legend border outline.}

\item{glyph_height}{The height (in pixels) that the rendered legend glyph should occupy.}

\item{glyph_width}{The width (in pixels) that the rendered legend glyph should occupy.}

\item{label_height}{The height (in pixels) of the area that legend labels should occupy.}

\item{label_standoff}{The distance (in pixels) to separate the label from its associated glyph.}

\item{label_text_align}{('left', 'right', 'center') The text align for the legend labels.}

\item{label_text_alpha}{The text alpha for the legend labels.}

\item{label_text_baseline}{('top', 'middle', 'bottom', 'alphabetic', 'hanging') The text baseline for the legend labels.}

\item{label_text_color}{The text color for the legend labels.}

\item{label_text_font}{The text font for the legend labels.}

\item{label_text_font_size}{The text font size for the legend labels.}

\item{label_text_font_style}{('normal', 'italic', 'bold') The text font style for the legend labels.}

\item{label_width}{The width (in pixels) of the area that legend labels should occupy.}

\item{legend_padding}{Amount of padding around the legend.}

\item{legend_spacing}{Amount of spacing between legend entries.}

\item{pars}{optionally specify a named list of all parameters - useful when dealing with theme lists}
}
\description{
Override theme parameters for legend attributes
}
\examples{
figure(legend_location = "top_left") \%>\%
  ly_points(1:10, legend = "a") \%>\%
  theme_legend(border_line_width = 2)
}
