% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_sunlit_canopy.R
\name{mask_sunlit_canopy}
\alias{mask_sunlit_canopy}
\title{Mask sunlit canopy}
\usage{
mask_sunlit_canopy(caim, m = NULL)
}
\arguments{
\item{caim}{\linkS4class{SpatRaster}. The return of a call to \code{\link[=read_caim]{read_caim()}} or
\code{\link[=read_caim_raw]{read_caim_raw()}}.}

\item{m}{\linkS4class{SpatRaster}. A mask. For hemispherical photographs, check
\code{\link[=mask_hs]{mask_hs()}}.}
}
\value{
An object of class \linkS4class{SpatRaster} with values \code{0} and \code{1}.
}
\description{
It is a wrapper function around \code{\link[=membership_to_color]{membership_to_color()}}. It was developed
with images in sRGB color space \insertCite{Diaz2023}{rcaiman}.
}
\examples{
\dontrun{
path <- system.file("external/APC_0020.jpg", package = "rcaiman")
caim <- read_caim(path)
plotRGB(caim)
caim <- normalize(caim)
m <- mask_sunlit_canopy(caim)
plot(m)
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Segmentation Functions: 
\code{\link{chessboard}()},
\code{\link{mask_hs}()},
\code{\link{polar_qtree}()},
\code{\link{qtree}()},
\code{\link{rings_segmentation}()},
\code{\link{sectors_segmentation}()},
\code{\link{sky_grid_segmentation}()}
}
\concept{Segmentation Functions}
