% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rcdf_as.R
\name{write_rcdf_xlsx}
\alias{write_rcdf_xlsx}
\title{Write RCDF data to Excel files}
\usage{
write_rcdf_xlsx(data, path, ..., parent_dir = NULL)
}
\arguments{
\item{data}{A valid RCDF object.}

\item{path}{The output directory.}

\item{...}{Additional arguments passed to \code{openxlsx::write.xlsx()}.}

\item{parent_dir}{Optional subdirectory under \code{path} to group Excel files.}
}
\value{
Invisibly returns \code{NULL}. Files are written to disk.
}
\description{
Writes each table in the RCDF object as a separate \code{.xlsx} file using the \code{openxlsx} package.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
temp_dir <- tempdir()

write_rcdf_xlsx(data = rcdf_data, path = temp_dir)

unlink(temp_dir, force = TRUE)
}
\seealso{
\link[rcdf]{write_rcdf_as}
}
