/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import javax.swing.undo.UndoableEdit;
import org.openscience.cdk.Atom;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.ChangeIsotopeEdit;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;

public class ChangeIsotopeAction
extends JCPAction {
    private static final long serialVersionUID = -4692219842740123315L;

    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)"About to change atom type of relevant atom!");
        JChemPaintModel jcpm = this.jcpPanel.getJChemPaintModel();
        if (jcpm != null) {
            IChemObject object = this.getSource(event);
            logger.debug((Object)"Source of call: ", (Object)object);
            if (object instanceof Atom) {
                Atom atom = (Atom)object;
                int isotopeNumber = 0;
                int formerIsotopeNumber = 0;
                try {
                    IIsotope isotope = IsotopeFactory.getInstance((IChemObjectBuilder)atom.getBuilder()).getMajorIsotope(atom.getSymbol());
                    formerIsotopeNumber = isotopeNumber = isotope.getMassNumber();
                }
                catch (Exception exception) {
                    logger.error((Object)"Error while configuring atom");
                    logger.debug((Object)exception);
                }
                if (!this.type.equals("major")) {
                    if (this.type.equals("majorPlusOne")) {
                        ++isotopeNumber;
                    } else if (this.type.equals("majorPlusTwo")) {
                        ++isotopeNumber;
                        ++isotopeNumber;
                    } else if (this.type.equals("majorPlusThree")) {
                        ++isotopeNumber;
                        ++isotopeNumber;
                        ++isotopeNumber;
                    } else if (this.type.equals("majorMinusOne")) {
                        --isotopeNumber;
                    } else if (this.type.equals("majorMinusTwo")) {
                        --isotopeNumber;
                        --isotopeNumber;
                    } else if (this.type.equals("majorMinusThree")) {
                        --isotopeNumber;
                        --isotopeNumber;
                        --isotopeNumber;
                    }
                }
                atom.setMassNumber(isotopeNumber);
                ChangeIsotopeEdit edit = new ChangeIsotopeEdit((IAtom)atom, formerIsotopeNumber, isotopeNumber);
                this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
                jcpm.fireChange();
            }
        }
    }
}

