/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.FontMetrics;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;

class Text {
    static final int XY = 0;
    static final int LEFT = 1;
    static final int CENTER = 2;
    static final int RIGHT = 3;
    static final int TOP = 1;
    static final int BOTTOM = 2;
    static final int MIDDLE = 3;
    boolean atomBased;
    Graphics3D g3d;
    String target;
    String text;
    String[] lines;
    int align;
    int valign;
    int movableX;
    int movableY;
    int offsetX;
    int offsetY;
    int z;
    int zSlab;
    int windowWidth;
    int windowHeight;
    boolean adjustForWindow;
    int boxX;
    int boxY;
    int boxWidth;
    int boxHeight;
    Font3D font3d;
    FontMetrics fm;
    byte fid;
    int ascent;
    int descent;
    int lineHeight;
    short colix;
    short bgcolix;
    int[] widths;
    int textWidth;
    int textHeight;

    Text(Graphics3D g3d, Font3D font3d, String text, short colix, short bgcolix, int offsetX, int offsetY, int z, int zSlab, int textAlign) {
        this.windowWidth = g3d.getRenderWidth();
        this.windowHeight = g3d.getRenderHeight();
        this.atomBased = true;
        this.g3d = g3d;
        this.text = text;
        this.colix = colix;
        this.bgcolix = bgcolix;
        this.setXYZs(offsetX, offsetY, z, zSlab);
        this.align = textAlign;
        this.setFont(font3d);
    }

    Text(Graphics3D g3d, Font3D font3d, String target, short colix, int valign, int align) {
        this.windowWidth = g3d.getRenderWidth();
        this.windowHeight = g3d.getRenderHeight();
        this.atomBased = false;
        this.g3d = g3d;
        this.target = target;
        this.align = align;
        this.valign = valign;
        this.font3d = font3d;
        this.colix = colix;
        this.z = 2;
        this.zSlab = Integer.MIN_VALUE;
        this.getFontMetrics();
    }

    void getFontMetrics() {
        this.fm = this.font3d.fontMetrics;
        this.descent = this.fm.getDescent();
        this.ascent = this.fm.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    void setFid(byte fid) {
        if (this.fid == fid) {
            return;
        }
        this.fid = fid;
        this.recalc();
    }

    void setAdjustForWindow(boolean TF) {
        this.adjustForWindow = TF;
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    void setColix(Object value) {
        this.colix = Graphics3D.getColix(value);
    }

    void setBgColix(short colix) {
        this.bgcolix = colix;
    }

    void setBgColix(Object value) {
        this.bgcolix = value == null ? (short)0 : Graphics3D.getColix(value);
    }

    void setMovableX(int x) {
        this.valign = 0;
        this.movableX = x;
    }

    void setMovableY(int y) {
        this.valign = 0;
        this.movableY = y;
    }

    void setXY(int x, int y) {
        this.setMovableX(x);
        this.setMovableY(y);
    }

    void setZs(int z, int zSlab) {
        this.z = z;
        this.zSlab = zSlab;
    }

    void setXYZs(int x, int y, int z, int zSlab) {
        this.setMovableX(x);
        this.setMovableY(y);
        this.setZs(z, zSlab);
    }

    void setPositions() {
        int xLeft;
        int xRight;
        int xCenter;
        if (this.valign == 0) {
            xRight = xCenter = this.movableX + this.offsetX;
            xLeft = xCenter;
        } else {
            xLeft = 5;
            xCenter = this.windowWidth / 2;
            xRight = this.windowWidth - 5;
        }
        this.boxX = xLeft;
        switch (this.align) {
            case 2: {
                this.boxX = xCenter - this.boxWidth / 2;
                break;
            }
            case 3: {
                this.boxX = xRight - this.boxWidth;
            }
        }
        this.boxY = 0;
        switch (this.valign) {
            case 1: {
                break;
            }
            case 3: {
                this.boxY = this.windowHeight / 2;
                break;
            }
            case 2: {
                this.boxY = this.windowHeight;
                break;
            }
            default: {
                this.boxY = this.movableY + this.offsetY;
            }
        }
        this.setBoxOffsetsInWindow();
    }

    void setOffset(int offset) {
        this.offsetX = Text.getXOffset(offset);
        this.offsetY = Text.getYOffset(offset);
        this.valign = 0;
    }

    static final int getXOffset(int offset) {
        switch (offset) {
            case 0: {
                return 4;
            }
            case 32767: {
                return 0;
            }
        }
        return (byte)(offset >> 8);
    }

    static final int getYOffset(int offset) {
        switch (offset) {
            case 0: {
                return -4;
            }
            case 32767: {
                return 0;
            }
        }
        return -((byte)(offset & 0xFF));
    }

    void setText(String text) {
        if (this.text != null && this.text.equals(text)) {
            return;
        }
        this.text = text;
        this.recalc();
    }

    void setFont(Font3D f3d) {
        this.font3d = f3d;
        this.getFontMetrics();
        this.recalc();
    }

    boolean setAlignment(String align) {
        if ("left".equals(align)) {
            return this.setAlignment(1);
        }
        if ("center".equals(align)) {
            return this.setAlignment(2);
        }
        if ("right".equals(align)) {
            return this.setAlignment(3);
        }
        return false;
    }

    boolean setAlignment(int align) {
        this.align = align;
        this.recalc();
        return true;
    }

    void recalc() {
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        this.lines = this.split(this.text, '|');
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int i = this.lines.length;
        while (--i >= 0) {
            this.widths[i] = this.fm.stringWidth(this.lines[i]);
            this.textWidth = Math.max(this.textWidth, this.widths[i]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + 8;
        this.boxHeight = this.textHeight + 8;
    }

    void render() {
        if (this.text == null) {
            return;
        }
        this.setPositions();
        if (this.bgcolix != 0) {
            this.drawBox();
        }
        int x0 = this.boxX + 4;
        switch (this.align) {
            case 2: {
                x0 = this.boxX + this.boxWidth / 2;
                break;
            }
            case 3: {
                x0 = this.boxX + this.boxWidth - 4;
            }
        }
        int x = x0;
        int y = this.boxY + this.ascent + 4;
        for (int i = 0; i < this.lines.length; ++i) {
            switch (this.align) {
                case 2: {
                    x = x0 - this.widths[i] / 2;
                    break;
                }
                case 3: {
                    x = x0 - this.widths[i];
                }
            }
            this.g3d.drawString(this.lines[i], this.font3d, this.colix, x, y, this.z, this.zSlab);
            y += this.lineHeight;
        }
    }

    private void drawBox() {
        this.g3d.fillRect(this.bgcolix, this.boxX, this.boxY, this.z + 2, this.zSlab, this.boxWidth, this.boxHeight);
        this.g3d.drawRect(this.colix, this.boxX + 1, this.boxY + 1, this.z + 1, this.zSlab, this.boxWidth - 2, this.boxHeight - 2);
    }

    void setBoxOffsetsInWindow() {
        int y0;
        int y;
        if (!this.adjustForWindow) {
            this.boxY -= this.lineHeight;
        }
        if (this.atomBased && this.align == 0) {
            this.boxX += 4;
            this.boxY -= 8;
        }
        if (!this.adjustForWindow) {
            return;
        }
        this.boxY -= this.textHeight;
        int x = this.boxX;
        if (x + this.boxWidth + 5 > this.windowWidth) {
            x = this.windowWidth - this.boxWidth - 5;
        }
        if (x < 5) {
            x = 5;
        }
        if ((y = this.boxY) + this.boxHeight > this.windowHeight) {
            y = this.windowHeight - this.boxHeight;
        }
        int n = y0 = this.atomBased ? 16 + this.lineHeight : 0;
        if (y < y0) {
            y = y0;
        }
        this.boxX = x;
        this.boxY = y;
    }

    static final void renderSimple(Graphics3D g3d, Font3D font3d, String strLabel, short colix, short bgcolix, int x, int y, int z, int zSlab, int xOffset, int yOffset, int ascent, int descent) {
        int xBoxOffset;
        if (strLabel == null || strLabel.length() == 0) {
            return;
        }
        int x0 = x;
        int y0 = y;
        int boxWidth = font3d.fontMetrics.stringWidth(strLabel) + 8;
        int boxHeight = ascent + descent + 8;
        if (xOffset > 0) {
            xBoxOffset = xOffset;
        } else {
            xBoxOffset = -boxWidth;
            xBoxOffset = xOffset == 0 ? (xBoxOffset /= 2) : (xBoxOffset += xOffset);
        }
        int yBoxOffset = yOffset > 0 ? yOffset : (yOffset == 0 ? -boxHeight / 2 - 2 : -boxHeight + yOffset);
        x += xBoxOffset;
        y += yBoxOffset;
        if (bgcolix != 0) {
            g3d.fillRect(bgcolix, x, y, z, zSlab, boxWidth, boxHeight);
            g3d.drawRect(colix, x + 1, y + 1, z - 1, zSlab, boxWidth - 2, boxHeight - 2);
            if (xOffset > 0) {
                g3d.drawLine(bgcolix, x0, y0, zSlab, x, y + boxHeight / 2, zSlab);
            }
        }
        g3d.drawString(strLabel, font3d, colix, x + 4, y + 4 + ascent, z - 1, zSlab);
    }

    String[] split(String text, char ch) {
        int n = 1;
        int i = text.indexOf(ch);
        if (i < 0) {
            String[] lines = new String[]{text};
            return lines;
        }
        int len = text.length();
        while (i < len) {
            if (text.charAt(i) == ch) {
                ++n;
            }
            ++i;
        }
        String[] lines = new String[n];
        i = 0;
        len = 0;
        int pt = 0;
        while ((len = text.indexOf(ch, i)) >= 0) {
            lines[pt++] = text.substring(i, len);
            i = len + 1;
        }
        lines[pt] = text.substring(i, text.length());
        return lines;
    }
}

