/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.PartialSigmaChargeDescriptorTest")
public class PartialSigmaChargeDescriptor
extends AbstractAtomicDescriptor {
    private static final String[] names = new String[]{"partialSigmaCharge"};
    private GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
    private int maxIterations;

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#partialSigmaCharge", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("PartialSigmaChargeDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter 1 must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        Double originalCharge = atom.getCharge();
        if (!this.isCachedAtomContainer(ac)) {
            IMolecule mol = atom.getBuilder().newInstance(IMolecule.class, ac);
            if (this.maxIterations != 0) {
                this.peoe.setMaxGasteigerIters(this.maxIterations);
            }
            try {
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(mol, true);
                for (int i = 0; i < ac.getAtomCount(); ++i) {
                    this.cacheDescriptorValue(ac.getAtom(i), ac, new DoubleResult(mol.getAtom(i).getCharge()));
                }
            }
            catch (Exception e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), names, e);
            }
        }
        atom.setCharge(originalCharge);
        return this.getCachedDescriptorValue(atom) != null ? new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.getCachedDescriptorValue(atom), names) : null;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

