/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.HINFormatTest")
public class HINFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    private HINFormat() {
    }

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new HINFormat();
        }
        return myself;
    }

    @Override
    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "HyperChem HIN";
    }

    @Override
    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return null;
    }

    @Override
    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"hin"};
    }

    @Override
    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.HINReader";
    }

    @Override
    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return "org.openscience.cdk.io.HINWriter";
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        StringTokenizer tokenizer;
        return line.startsWith("atom ") && (line.endsWith(" s") || line.endsWith(" d") || line.endsWith(" t") || line.endsWith(" a")) && (tokenizer = new StringTokenizer(line, " ")).countTokens() % 2 == 0;
    }

    @Override
    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @Override
    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 0x200;
    }

    @Override
    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 26;
    }
}

