/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.faster;

import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.query.Applyer;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Matcher;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.QueryTriple;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.mem.faster.FasterTripleStore;
import com.hp.hpl.jena.mem.faster.GraphMemFasterQueryHandler;
import com.hp.hpl.jena.mem.faster.NodeToTriplesMapFaster;
import com.hp.hpl.jena.mem.faster.ProcessedTriple;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphMemFaster
extends GraphMemBase {
    public GraphMemFaster() {
        this(ReificationStyle.Minimal);
    }

    public GraphMemFaster(ReificationStyle style) {
        super(style);
    }

    @Override
    protected TripleStore createTripleStore() {
        return new FasterTripleStore(this);
    }

    @Override
    protected void destroy() {
        this.store.close();
    }

    @Override
    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.store.add(t);
        }
    }

    @Override
    public void performDelete(Triple t) {
        if (!this.getReifier().handledRemove(t)) {
            this.store.delete(t);
        }
    }

    @Override
    public int graphBaseSize() {
        return this.store.size();
    }

    @Override
    public QueryHandler queryHandler() {
        if (this.queryHandler == null) {
            this.queryHandler = new GraphMemFasterQueryHandler(this);
        }
        return this.queryHandler;
    }

    @Override
    protected GraphStatisticsHandler createStatisticsHandler() {
        return new GraphMemFasterStatisticsHandler((FasterTripleStore)this.store, this.getReifier());
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        return this.store.find(m.asTriple());
    }

    public Applyer createApplyer(ProcessedTriple pt) {
        Applyer plain = ((FasterTripleStore)this.store).createApplyer(pt);
        return GraphMemFaster.matchesReification(pt) && this.hasReifications() ? this.withReification(plain, pt) : plain;
    }

    protected boolean hasReifications() {
        return this.reifier != null && this.reifier.size() > 0;
    }

    public static boolean matchesReification(QueryTriple pt) {
        return pt.P.node.isVariable() || Reifier.Util.isReificationPredicate(pt.P.node) || Reifier.Util.isReificationType(pt.P.node, pt.O.node);
    }

    protected Applyer withReification(final Applyer plain, final QueryTriple pt) {
        return new Applyer(){

            public void applyToTriples(Domain d, Matcher m, StageElement next) {
                plain.applyToTriples(d, m, next);
                Triple tm = new Triple(pt.S.finder(d), pt.P.finder(d), pt.O.finder(d));
                ExtendedIterator<Triple> it = GraphMemFaster.this.reifier.findExposed(tm);
                while (it.hasNext()) {
                    if (!m.match(d, (Triple)it.next())) continue;
                    next.run(d);
                }
            }
        };
    }

    @Override
    public boolean graphBaseContains(Triple t) {
        return t.isConcrete() ? this.store.contains(t) : super.graphBaseContains(t);
    }

    @Override
    public void clear() {
        this.store.clear();
        ((SimpleReifier)this.getReifier()).clear();
    }

    protected static class GraphMemFasterStatisticsHandler
    implements GraphStatisticsHandler {
        protected final FasterTripleStore store;
        protected final Reifier reifier;

        public GraphMemFasterStatisticsHandler(FasterTripleStore store, Reifier reifier) {
            this.store = store;
            this.reifier = reifier;
        }

        public long getStatistic(Node S, Node P, Node O) {
            if (this.reifier.size() > 0) {
                return -1L;
            }
            int concrete = (S.isConcrete() ? 1 : 0) + (P.isConcrete() ? 2 : 0) + (O.isConcrete() ? 4 : 0);
            switch (concrete) {
                case 0: {
                    return this.store.size();
                }
                case 1: {
                    return this.countInMap(S, this.store.getSubjects());
                }
                case 3: {
                    return this.countsInMap(S, this.store.getSubjects(), P, this.store.getPredicates());
                }
                case 5: {
                    return this.countsInMap(S, this.store.getSubjects(), O, this.store.getObjects());
                }
                case 2: {
                    return this.countInMap(P, this.store.getPredicates());
                }
                case 6: {
                    return this.countsInMap(P, this.store.getPredicates(), O, this.store.getObjects());
                }
                case 4: {
                    return this.countInMap(O, this.store.getObjects());
                }
                case 7: {
                    return this.store.contains(Triple.create(S, P, O)) ? 1L : 0L;
                }
            }
            return -1L;
        }

        public long countsInMap(Node a, NodeToTriplesMapFaster mapA, Node b, NodeToTriplesMapFaster mapB) {
            long countA = this.countInMap(a, mapA);
            long countB = this.countInMap(b, mapB);
            return countA == 0L || countB == 0L ? 0L : -1L;
        }

        public long countInMap(Node n, NodeToTriplesMapFaster map) {
            TripleBunch b = map.get(n.getIndexingValue());
            return b == null ? 0L : (long)b.size();
        }

        private static class C {
            static final int NONE = 0;
            static final int S = 1;
            static final int P = 2;
            static final int O = 4;
            static final int SP = 3;
            static final int SO = 5;
            static final int PO = 6;
            static final int SPO = 7;

            private C() {
            }
        }
    }
}

