/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.validate;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.validate.IValidator;
import org.openscience.cdk.validate.ValidationReport;

public class ValidatorEngine
implements IValidator {
    private Map<String, IValidator> validators = new Hashtable<String, IValidator>();
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ValidatorEngine.class);

    public void addValidator(IValidator validator) {
        logger.info("Registering validator: " + validator.getClass().getName());
        String validatorName = validator.getClass().getName();
        if (this.validators.containsKey(validatorName)) {
            logger.warn("  already registered.");
        } else {
            this.validators.put(validatorName, validator);
        }
    }

    public void removeValidator(IValidator validator) {
        logger.info("Removing validator: " + validator.getClass().getName());
        String validatorName = validator.getClass().getName();
        if (!this.validators.containsKey(validatorName)) {
            logger.warn("  not in list.");
        } else {
            this.validators.remove(validatorName);
        }
    }

    public ValidationReport validateAtom(IAtom subject) {
        logger.info("Validating org.openscience.cdk.Atom");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateAtom(subject));
        }
        report.addReport(this.validateAtomType(subject));
        return report;
    }

    public ValidationReport validateAtomContainer(IAtomContainer subject) {
        logger.info("Validating org.openscience.cdk.AtomContainer");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateAtomContainer(subject));
        }
        report.addReport(this.validateChemObject(subject));
        Iterator<IAtom> atoms = subject.atoms().iterator();
        while (atoms.hasNext()) {
            report.addReport(this.validateAtom(atoms.next()));
        }
        for (IBond bond : subject.bonds()) {
            report.addReport(this.validateBond(bond));
        }
        return report;
    }

    public ValidationReport validateAtomType(IAtomType subject) {
        logger.info("Validating org.openscience.cdk.AtomType");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateAtomType(subject));
        }
        report.addReport(this.validateIsotope(subject));
        return report;
    }

    public ValidationReport validateBond(IBond subject) {
        logger.info("Validating org.openscience.cdk.Bond");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateBond(subject));
        }
        report.addReport(this.validateElectronContainer(subject));
        Iterator<IAtom> atoms = subject.atoms().iterator();
        while (atoms.hasNext()) {
            report.addReport(this.validateAtom(atoms.next()));
        }
        return report;
    }

    public ValidationReport validateChemFile(IChemFile subject) {
        logger.info("Validating org.openscience.cdk.ChemFile");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateChemFile(subject));
        }
        report.addReport(this.validateChemObject(subject));
        for (int i = 0; i < subject.getChemSequenceCount(); ++i) {
            report.addReport(this.validateChemSequence(subject.getChemSequence(i)));
        }
        return report;
    }

    public ValidationReport validateChemModel(IChemModel subject) {
        IAtomContainerSet moleculeSet;
        IReactionSet reactionSet;
        logger.info("Validating org.openscience.cdk.ChemModel");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateChemModel(subject));
        }
        report.addReport(this.validateChemObject(subject));
        ICrystal crystal = subject.getCrystal();
        if (crystal != null) {
            report.addReport(this.validateCrystal(crystal));
        }
        if ((reactionSet = subject.getReactionSet()) != null) {
            report.addReport(this.validateReactionSet(reactionSet));
        }
        if ((moleculeSet = subject.getMoleculeSet()) != null) {
            report.addReport(this.validateMoleculeSet(moleculeSet));
        }
        return report;
    }

    public ValidationReport validateChemObject(IChemObject subject) {
        logger.info("Validating org.openscience.cdk.ChemObject");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateChemObject(subject));
        }
        return report;
    }

    public ValidationReport validateChemSequence(IChemSequence subject) {
        logger.info("Validating org.openscience.cdk.ChemSequence");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateChemSequence(subject));
        }
        report.addReport(this.validateChemObject(subject));
        Iterator<IChemModel> models = subject.chemModels().iterator();
        while (models.hasNext()) {
            report.addReport(this.validateChemModel(models.next()));
        }
        return report;
    }

    public ValidationReport validateCrystal(ICrystal subject) {
        logger.info("Validating org.openscience.cdk.Crystal");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateCrystal(subject));
        }
        report.addReport(this.validateAtomContainer(subject));
        return report;
    }

    public ValidationReport validateElectronContainer(IElectronContainer subject) {
        logger.info("Validating org.openscience.cdk.ElectronContainer");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateElectronContainer(subject));
        }
        report.addReport(this.validateChemObject(subject));
        return report;
    }

    public ValidationReport validateElement(IElement subject) {
        logger.info("Validating org.openscience.cdk.Element");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateElement(subject));
        }
        report.addReport(this.validateChemObject(subject));
        return report;
    }

    public ValidationReport validateIsotope(IIsotope subject) {
        logger.info("Validating org.openscience.cdk.Isotope");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateIsotope(subject));
        }
        report.addReport(this.validateElement(subject));
        return report;
    }

    public ValidationReport validateMolecule(IAtomContainer subject) {
        logger.info("Validating org.openscience.cdk.Molecule");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateMolecule(subject));
        }
        report.addReport(this.validateAtomContainer(subject));
        return report;
    }

    public ValidationReport validateReaction(IReaction subject) {
        logger.info("Validating org.openscience.cdk.Reaction");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateReaction(subject));
        }
        report.addReport(this.validateChemObject(subject));
        IAtomContainerSet reactants = subject.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            report.addReport(this.validateMolecule(reactants.getAtomContainer(i)));
        }
        IAtomContainerSet products = subject.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            report.addReport(this.validateMolecule(products.getAtomContainer(i)));
        }
        return report;
    }

    public ValidationReport validateMoleculeSet(IAtomContainerSet subject) {
        logger.info("Validating org.openscience.cdk.MoleculeSet");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateMoleculeSet(subject));
        }
        report.addReport(this.validateChemObject(subject));
        for (int i = 0; i < subject.getAtomContainerCount(); ++i) {
            report.addReport(this.validateMolecule(subject.getAtomContainer(i)));
        }
        return report;
    }

    public ValidationReport validateReactionSet(IReactionSet subject) {
        logger.info("Validating org.openscience.cdk.ReactionSet");
        ValidationReport report = new ValidationReport();
        for (IValidator test : this.validators.values()) {
            report.addReport(test.validateReactionSet(subject));
        }
        report.addReport(this.validateChemObject(subject));
        Iterator<IReaction> iter = subject.reactions().iterator();
        while (iter.hasNext()) {
            report.addReport(this.validateReaction(iter.next()));
        }
        return report;
    }
}

