/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import org.openscience.cdk.Bond;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.pharmacophore.PharmacophoreAngleBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAtom;

public class PharmacophoreQueryAngleBond
extends Bond
implements IQueryBond {
    private double upper;
    private double lower;

    public PharmacophoreQueryAngleBond() {
    }

    public PharmacophoreQueryAngleBond(PharmacophoreQueryAtom atom1, PharmacophoreQueryAtom atom2, PharmacophoreQueryAtom atom3, double lower, double upper) {
        super(new IAtom[]{atom1, atom2, atom3});
        this.upper = this.round(upper, 2);
        this.lower = this.round(lower, 2);
    }

    public PharmacophoreQueryAngleBond(PharmacophoreQueryAtom atom1, PharmacophoreQueryAtom atom2, PharmacophoreQueryAtom atom3, double angle) {
        super(new PharmacophoreQueryAtom[]{atom1, atom2, atom3});
        this.upper = this.round(angle, 2);
        this.lower = this.round(angle, 2);
    }

    @Override
    public boolean matches(IBond bond) {
        if (bond instanceof PharmacophoreAngleBond) {
            PharmacophoreAngleBond pbond = (PharmacophoreAngleBond)bond;
            double bondLength = this.round(pbond.getBondLength(), 2);
            return bondLength >= this.lower && bondLength <= this.upper;
        }
        return false;
    }

    public double getUpper() {
        return this.upper;
    }

    public double getLower() {
        return this.lower;
    }

    private double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AC::").append(this.getAtom(0)).append("::").append(this.getAtom(1)).append("::").append(this.getAtom(2));
        sb.append("::[").append(this.getLower()).append(" - ").append(this.getUpper()).append("] ");
        return sb.toString();
    }
}

