/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.element.AbstractProperty;
import org.xmlcml.cml.element.CMLPropertyList;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.cml.interfacex.HasArraySize;
import org.xmlcml.cml.interfacex.HasDataType;
import org.xmlcml.cml.interfacex.HasDictRef;
import org.xmlcml.cml.interfacex.HasScalar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLProperty
extends AbstractProperty
implements HasDictRef {
    public static final String NS = "cml:property";
    private HasDataType child;

    public CMLProperty() {
    }

    public CMLProperty(CMLProperty old) {
        super(old);
    }

    public CMLProperty(String dictRef, double value, String units) {
        this();
        CMLScalar scalar = new CMLScalar(value);
        scalar.setUnits(units);
        this.appendChild(scalar);
        this.setDictRef(dictRef);
    }

    @Override
    public Node copy() {
        return new CMLProperty(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLProperty();
    }

    public static CMLPropertyList getPropertyList(CMLElement parent, String dictRef) {
        CMLPropertyList propertyList = new CMLPropertyList();
        Nodes nodes = parent.query("./cml:property", CMLConstants.CML_XPATH);
        for (int i = 0; i < nodes.size(); ++i) {
            CMLProperty property = (CMLProperty)nodes.get(i);
            property.canonicalize();
            if (!dictRef.equals(property.getAttributeValue("dictRef"))) continue;
            propertyList.addProperty(property);
        }
        return propertyList;
    }

    public static CMLProperty getProperty(CMLElement parent, String dictRef) {
        CMLPropertyList propertyList = CMLProperty.getPropertyList(parent, dictRef);
        CMLElements<CMLProperty> properties = propertyList.getPropertyElements();
        CMLProperty property = null;
        if (properties.size() == 1) {
            property = properties.get(0);
        }
        return property;
    }

    public void canonicalize() {
        CMLProperty.staticCanonicalize(this);
    }

    static void staticCanonicalize(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        if (child != null) {
            String thisDictRef = ((HasDictRef)((Object)element)).getDictRef();
            String childDictRef = child.getDictRef();
            if (thisDictRef == null) {
                if (childDictRef == null) {
                    throw new RuntimeException("No dictRef attribute given: ");
                }
                ((HasDictRef)((Object)element)).setDictRef(childDictRef);
            } else if (childDictRef != null && !thisDictRef.equals(childDictRef)) {
                throw new RuntimeException("inconsistent dictRefs: " + thisDictRef + " // " + childDictRef);
            }
            String units = CMLProperty.getStaticUnits(element);
            String dataType = CMLType.getNormalizedValue(child.getDataType());
            if (units != null) {
                if (!dataType.equals("xsd:double")) {
                    child.setDataType("xsd:double");
                    throw new RuntimeException("units require data type of double");
                }
            } else if (dataType.equals("xsd:double")) {
                throw new RuntimeException("dataType not double");
            }
        }
    }

    public String getUnits() {
        return CMLProperty.getStaticUnits(this);
    }

    public double getDouble() {
        return CMLProperty.getStaticDouble(this);
    }

    public String getString() {
        return CMLProperty.getStaticString(this);
    }

    public int getInt() {
        return CMLProperty.getStaticInt(this);
    }

    public List<String> getStringValues() {
        return CMLProperty.getStaticStringValues(this);
    }

    public int[] getInts() {
        return CMLProperty.getStaticInts(this);
    }

    public double[] getDoubles() {
        return CMLProperty.getStaticDoubles(this);
    }

    public HasDataType getChild() {
        if (this.child == null) {
            this.child = CMLProperty.getStaticChild(this);
        }
        return this.child;
    }

    public void setChild(HasDataType child) {
        this.child = child;
    }

    public String getDataType() {
        return CMLProperty.getStaticDataType(this);
    }

    static String getStaticUnits(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        String units = ((CMLElement)((Object)child)).getAttributeValue("units");
        return units;
    }

    static double getStaticDouble(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        double result = Double.NaN;
        String dataType = CMLType.getNormalizedValue(CMLProperty.getStaticDataType(child));
        if ("xsd:double".equals(dataType) && child instanceof HasScalar) {
            result = ((HasScalar)child).getDouble();
        }
        return result;
    }

    static String getStaticDataType(HasDataType hasDataType) {
        return hasDataType.getDataType();
    }

    static String getStaticString(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        String result = null;
        if ("xsd:string".equals(child.getDataType()) && child instanceof HasScalar) {
            result = ((HasScalar)child).getString();
        }
        return result;
    }

    static int getStaticInt(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        int result = Integer.MIN_VALUE;
        String dataType = CMLType.getNormalizedValue(child.getDataType());
        if ("xsd:integer".equals(dataType) && child instanceof HasScalar) {
            result = ((HasScalar)child).getInt();
        }
        return result;
    }

    static List<String> getStaticStringValues(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        List<String> result = null;
        String dataType = CMLType.getNormalizedValue(child.getDataType());
        if ("xsd:string".equals(dataType) && child instanceof HasArraySize) {
            result = ((HasArraySize)child).getStringValues();
        }
        return result;
    }

    static int[] getStaticInts(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        int[] result = null;
        String dataType = CMLType.getNormalizedValue(child.getDataType());
        if ("xsd:integer".equals(dataType) && child instanceof HasArraySize) {
            result = ((HasArraySize)child).getInts();
        }
        return result;
    }

    static double[] getStaticDoubles(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        double[] result = null;
        String dataType = CMLType.getNormalizedValue(child.getDataType());
        if ("xsd:double".equals(dataType) && child instanceof HasArraySize) {
            result = ((HasArraySize)child).getDoubles();
        }
        return result;
    }

    static HasDataType getStaticChild(CMLElement element) {
        HasDataType dataType = null;
        Nodes nodes = element.query("cml:scalar | cml:array | cml:matrix", CMLConstants.CML_XPATH);
        if (nodes.size() == 1) {
            dataType = (HasDataType)((Object)nodes.get(0));
        }
        return dataType;
    }

    static String getStaticDataType(CMLElement element) {
        HasDataType child = CMLProperty.getStaticChild(element);
        String dataType = child == null ? null : child.getDataType();
        return CMLType.getNormalizedValue(dataType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Prop {
        DENSITY("cml:density"),
        MOLAR_MASS("cml:molarMass"),
        MOLAR_VOLUME("cml:molarVolume");

        public final String value;

        private Prop(String s) {
            this.value = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INTENSIVE("intensive"),
        EXTENSIVE("extensive"),
        SEMINTENSIVE("semintensive");

        public String value;

        private Type(String t) {
            this.value = t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DictRef {
        APPEARANCE("appearance"),
        AUTO_IGNITION("autoIgnition"),
        BPT("bpt"),
        DENSITY("density"),
        DIPOLE("dipole"),
        FLASH_POINT("flashPoint"),
        KH("kh"),
        LOGP("logP"),
        LOGPOW("logPow"),
        MOLARMASS("molarMass"),
        MPT("mpt"),
        MWT("mwt"),
        PKA("pka"),
        PKB("pkb"),
        REFRACTIVE_INDEX("refractiveIndex"),
        RELATIVE_DENSITY("relativeDensity"),
        RELATIVE_VAPOUR_DENSITY("relativeVapourDensity"),
        SOLUBILITY("solubility"),
        VAPOR_PRESSURE("vaporPressure"),
        VISCOSITY("viscosity"),
        WATER_SOLUBILITY("waterSolubility");

        public String v;
        private Map<String, DictRef> map = new HashMap<String, DictRef>();

        private DictRef(String v) {
            this.v = v;
            this.map.put(v, this);
        }

        public DictRef get(String v) {
            return this.map.get(v);
        }
    }
}

