/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractSpectrum;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLPeak;
import org.xmlcml.cml.element.CMLPeakList;
import org.xmlcml.cml.element.CMLPeakStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLSpectrum
extends AbstractSpectrum {
    public static final String NS = "cml:spectrum";

    public CMLSpectrum() {
    }

    public CMLSpectrum(CMLSpectrum old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLSpectrum(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLSpectrum();
    }

    public CMLMolecule getSiblingMolecule() {
        CMLMolecule molecule = null;
        ParentNode parent = this.getParent();
        if (parent != null) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                Node node = parent.getChild(i);
                if (!(node instanceof CMLMolecule)) continue;
                if (molecule != null) {
                    throw new RuntimeException("duplicate sibling molecules");
                }
                molecule = (CMLMolecule)node;
            }
        }
        return molecule;
    }

    public static CMLSpectrum getSpectrum(CMLElement element) {
        ParentNode parent;
        CMLSpectrum spectrum = null;
        ParentNode node = element;
        while ((parent = node.getParent()) != null) {
            if (parent instanceof CMLSpectrum) {
                spectrum = (CMLSpectrum)parent;
            }
            node = parent;
        }
        return spectrum;
    }

    public static CMLMolecule getAuntMolecule(CMLElement element) {
        CMLMolecule molecule = null;
        CMLSpectrum spectrum = CMLSpectrum.getSpectrum(element);
        if (spectrum != null) {
            molecule = spectrum.getSiblingMolecule();
        }
        return molecule;
    }

    public List<CMLPeak> getCouplingsTo(CMLAtom atom) {
        ArrayList<CMLPeak> peaksFound = new ArrayList<CMLPeak>();
        CMLMolecule molecule = atom.getMolecule();
        CMLElements<CMLPeakList> peakLists = this.getPeakListElements();
        for (CMLPeakList peakList : peakLists) {
            CMLElements<CMLPeak> peaks = peakList.getPeakElements();
            for (CMLPeak peak : peaks) {
                CMLElements<CMLPeakStructure> peakStructures = peak.getPeakStructureElements();
                for (CMLPeakStructure peakStructure : peakStructures) {
                    List<CMLAtom> atoms = molecule.getAtomListByIds(peakStructure.getAtomRefs());
                    if (!atoms.contains(atom)) continue;
                    peaksFound.add(peak);
                }
            }
        }
        return peaksFound;
    }

    public static List<CMLPeak> getDescendantPeaks(CMLElement element) {
        ArrayList<CMLPeak> peakList = new ArrayList<CMLPeak>();
        CMLSpectrum.getDescendantPeaks(element, peakList);
        return peakList;
    }

    private static void getDescendantPeaks(CMLElement element, List<CMLPeak> peakList) {
        if (element != null && element instanceof CMLElement) {
            for (CMLElement child : element.getChildCMLElements()) {
                if (child instanceof CMLPeak) {
                    peakList.add((CMLPeak)child);
                    continue;
                }
                CMLSpectrum.getDescendantPeaks(child, peakList);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpectrumType {
        UNKNOWN,
        IR,
        RAMAN,
        UV,
        FLUORESCENCE,
        NMR,
        MASS,
        CHROMATOGRAM,
        UNSUPPORTED;

    }
}

