/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.io.IOException;
import java.util.Iterator;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.InductiveAtomicHardnessDescriptorTest")
public class InductiveAtomicHardnessDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String[] names = new String[]{"indAtomHardnesss"};
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(InductiveAtomicHardnessDescriptor.class);
    private AtomTypeFactory factory = null;

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#atomicHardness", this.getClass().getName(), "$Id: f7de2072c82b79e0215720d45a02b205f1b60daa $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), names, e);
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        double radiusTarget;
        IAtomType type;
        String symbol;
        if (this.factory == null) {
            try {
                this.factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/jmol_atomtypes.txt", ac.getBuilder());
            }
            catch (Exception exception) {
                return this.getDummyDescriptorValue(exception);
            }
        }
        Iterator<IAtom> allAtoms = ac.atoms().iterator();
        double atomicHardness = 0.0;
        try {
            symbol = atom.getSymbol();
            type = this.factory.getAtomType(symbol);
            radiusTarget = type.getCovalentRadius();
        }
        catch (Exception exception) {
            logger.debug(exception);
            return this.getDummyDescriptorValue(exception);
        }
        while (allAtoms.hasNext()) {
            IAtom curAtom = allAtoms.next();
            if (atom.getPoint3d() == null || curAtom.getPoint3d() == null) {
                return this.getDummyDescriptorValue(new CDKException("The target atom or current atom had no 3D coordinates. These are required"));
            }
            if (atom.equals(curAtom)) continue;
            double partial = 0.0;
            symbol = curAtom.getSymbol();
            try {
                type = this.factory.getAtomType(symbol);
            }
            catch (Exception exception) {
                logger.debug(exception);
                return this.getDummyDescriptorValue(exception);
            }
            double radius = type.getCovalentRadius();
            partial += radius * radius;
            partial += radiusTarget * radiusTarget;
            atomicHardness += (partial /= this.calculateSquareDistanceBetweenTwoAtoms(atom, curAtom));
        }
        atomicHardness = 2.0 * atomicHardness;
        atomicHardness *= 0.172;
        atomicHardness = 1.0 / atomicHardness;
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(atomicHardness), names);
    }

    private double calculateSquareDistanceBetweenTwoAtoms(IAtom atom1, IAtom atom2) {
        Point3d firstPoint = atom1.getPoint3d();
        Point3d secondPoint = atom2.getPoint3d();
        double tmp = firstPoint.distance(secondPoint);
        double distance = tmp * tmp;
        return distance;
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

