/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.ReactionSceneGenerator;

@TestClass(value="org.openscience.cdk.renderer.generators.ReactantsBoxGeneratorTest")
public class ReactantsBoxGenerator
implements IGenerator<IReaction> {
    @Override
    @TestMethod(value="testEmptyReaction")
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        if (!((Boolean)model.getParameter(ReactionSceneGenerator.ShowReactionBoxes.class).getValue()).booleanValue()) {
            return null;
        }
        if (reaction.getReactantCount() == 0) {
            return new ElementGroup();
        }
        double separation = (Double)model.getParameter(BasicSceneGenerator.BondLength.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue() / 2.0;
        Rectangle2D totalBounds = BoundsCalculator.calculateBounds(reaction.getReactants());
        ElementGroup diagram = new ElementGroup();
        double minX = totalBounds.getMinX();
        double minY = totalBounds.getMinY();
        double maxX = totalBounds.getMaxX();
        double maxY = totalBounds.getMaxY();
        Color foregroundColor = (Color)model.getParameter(BasicSceneGenerator.ForegroundColor.class).getValue();
        diagram.add(new RectangleElement(minX - separation, minY - separation, maxX + separation, maxY + separation, foregroundColor));
        diagram.add(new TextElement((minX + maxX) / 2.0, minY - separation, "Reactants", foregroundColor));
        return diagram;
    }

    @Override
    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[0]);
    }
}

