/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.Attributes;

public class JMOLANIMATIONConvention
extends CMLCoreModule {
    private final int UNKNOWN = -1;
    private final int ENERGY = 1;
    private int current;
    private String frame_energy;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(JMOLANIMATIONConvention.class);

    public JMOLANIMATIONConvention(IChemFile chemFile) {
        super(chemFile);
        this.current = -1;
    }

    public JMOLANIMATIONConvention(ICMLModule conv) {
        super(conv);
    }

    @Override
    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        String name = local;
        if (name.equals("list")) {
            logger.debug((Object)"Oke, JMOLANIMATION seems to be kicked in :)");
            this.currentChemSequence = (IChemSequence)this.currentChemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            super.startElement(xpath, uri, local, raw, atts);
        } else if (name.equals("molecule")) {
            this.currentChemModel = (IChemModel)this.currentChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
            logger.debug((Object)"New frame being parsed.");
            super.startElement(xpath, uri, local, raw, atts);
        } else if (name.equals("float")) {
            boolean isEnergy = false;
            logger.debug((Object)"FLOAT found!");
            for (int i = 0; i < atts.getLength(); ++i) {
                logger.debug((Object)" att: ", new Object[]{atts.getQName(i), " -> ", atts.getValue(i)});
                if (!atts.getQName(i).equals("title") || !atts.getValue(i).equals("FRAME_ENERGY")) continue;
                isEnergy = true;
            }
            if (isEnergy) {
                this.current = 1;
            } else {
                super.startElement(xpath, uri, local, raw, atts);
            }
        } else {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    @Override
    public void endElement(CMLStack xpath, String uri, String local, String raw) {
        String name = local;
        if (this.current == 1) {
            this.current = -1;
            this.frame_energy = "";
        } else if (name.equals("list")) {
            super.endElement(xpath, uri, local, raw);
            this.currentChemFile.addChemSequence(this.currentChemSequence);
        } else if (name.equals("molecule")) {
            super.endElement(xpath, uri, local, raw);
        } else {
            super.endElement(xpath, uri, local, raw);
        }
    }

    @Override
    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        if (this.current == 1) {
            this.frame_energy = new String(ch, start, length);
        } else {
            super.characterData(xpath, ch, start, length);
        }
    }
}

