/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.dict;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.dict.Dictionary;
import org.openscience.cdk.dict.Entry;
import org.openscience.cdk.dict.OWLFile;
import org.openscience.cdk.dict.OWLReact;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DictionaryDatabase {
    private static final Map<String, Dictionary> cache = new HashMap<String, Dictionary>();
    public static final String DICTREFPROPERTYNAME = "org.openscience.cdk.dict";
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(DictionaryDatabase.class);
    private String[] dictionaryNames = new String[]{"chemical", "elements", "descriptor-algorithms", "reaction-processes"};
    private String[] dictionaryTypes = new String[]{"xml", "owl", "owl", "owl_React"};
    private Map<String, Dictionary> dictionaries = new Hashtable<String, Dictionary>();

    public DictionaryDatabase() {
        for (int i = 0; i < this.dictionaryNames.length; ++i) {
            String name = this.dictionaryNames[i];
            String type = this.dictionaryTypes[i];
            Dictionary dictionary = this.readDictionary("org/openscience/cdk/dict/data/" + name, type);
            if (dictionary == null) continue;
            this.dictionaries.put(name.toLowerCase(), dictionary);
            this.logger.debug("Read dictionary: ", name);
        }
    }

    private Dictionary readDictionary(String databaseLocator, String type) {
        Dictionary dictionary;
        databaseLocator = type.contains("_React") ? databaseLocator + "." + type.substring(0, type.length() - 6) : databaseLocator + "." + type;
        if (cache.containsKey(databaseLocator)) {
            return cache.get(databaseLocator);
        }
        this.logger.info("Reading dictionary from ", databaseLocator);
        try {
            InputStreamReader reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(databaseLocator));
            dictionary = type.equals("owl") ? OWLFile.unmarshal(reader) : (type.equals("owl_React") ? OWLReact.unmarshal(reader) : Dictionary.unmarshal(reader));
        }
        catch (Exception exception) {
            dictionary = null;
            this.logger.error("Could not read dictionary ", databaseLocator);
            this.logger.debug(exception);
        }
        cache.put(databaseLocator, dictionary);
        return dictionary;
    }

    public void readDictionary(Reader reader, String name) {
        name = name.toLowerCase();
        this.logger.debug("Reading dictionary: ", name);
        if (!this.dictionaries.containsKey(name)) {
            try {
                Dictionary dictionary = Dictionary.unmarshal(reader);
                this.dictionaries.put(name, dictionary);
                this.logger.debug("  ... loaded and stored");
            }
            catch (Exception exception) {
                this.logger.error("Could not read dictionary: ", name);
                this.logger.debug(exception);
            }
        } else {
            this.logger.error("Dictionary already loaded: ", name);
        }
    }

    public String[] getDictionaryNames() {
        return this.dictionaryNames;
    }

    public Dictionary getDictionary(String dictionaryName) {
        return this.dictionaries.get(dictionaryName);
    }

    public String[] getDictionaryEntries(String dictionaryName) {
        Dictionary dictionary = this.getDictionary(dictionaryName);
        if (dictionary == null) {
            this.logger.error("Cannot find requested dictionary");
            return new String[0];
        }
        Entry[] entries = dictionary.getEntries();
        String[] entryNames = new String[entries.length];
        this.logger.info("Found ", "" + entryNames.length, " entries in dictionary ", dictionaryName);
        for (int i = 0; i < entries.length; ++i) {
            entryNames[i] = entries[i].getLabel();
        }
        return entryNames;
    }

    public Entry[] getDictionaryEntry(String dictionaryName) {
        Dictionary dictionary = this.dictionaries.get(dictionaryName);
        return dictionary.getEntries();
    }

    public boolean hasDictionary(String name) {
        return this.dictionaries.containsKey(name.toLowerCase());
    }

    public Iterator<String> listDictionaries() {
        return this.dictionaries.keySet().iterator();
    }

    public boolean hasEntry(String dictName, String entryID) {
        if (this.hasDictionary(dictName)) {
            Dictionary dictionary = this.dictionaries.get(dictName);
            return dictionary.hasEntry(entryID.toLowerCase());
        }
        return false;
    }
}

