/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula.rules;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class ChargeRule
implements IRule {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ChargeRule.class);
    private double charge = 0.0;

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("ChargeRule expects only one parameter");
        }
        if (!(params[0] instanceof Double)) {
            throw new CDKException("The parameter must be of type Double");
        }
        this.charge = (Double)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.charge};
        return params;
    }

    @Override
    public double validate(IMolecularFormula formula) throws CDKException {
        logger.info("Start validation of ", formula);
        if (formula.getCharge() == null) {
            return 0.0;
        }
        if ((double)formula.getCharge().intValue() == this.charge) {
            return 1.0;
        }
        return 0.0;
    }
}

