% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-seaspctl.R, R/family-seaspctl.R
\name{cdo_seaspctl}
\alias{cdo_seaspctl}
\alias{seaspctl}
\title{Seasonal percentile values}
\usage{
cdo_seaspctl(ifile1, ifile2, ifile3, p = NULL, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2, ifile3}{Strings with the path to the input files.}

\item{p}{FLOAT - Percentile number in \{0, ..., 100\}}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This operator computes percentiles over all timesteps in infile1 of the same season. The algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3, respectively. The default number of histogram bins is 101. The default can be overridden by defining the environment variable CDO_PCTL_NBINS. The files infile2 and infile3 should be the result of corresponding seasmin and seasmax operations, respectively. The time of outfile is determined by the time in the middle of all contributing timesteps of infile1. This can be change with the CDO option --timestat_date <first|middle|last>. Be careful about the first and the last output timestep, they may be incorrect values if the seasons have incomplete timesteps. For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:  o(t,x) = pth percentile \{i(t',x), t1 < t' <= tn\}
}
