% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcensT2.R
\name{rcensT2}
\alias{rcensT2}
\title{Generate Censoring Sample, Type II}
\usage{
rcensT2(
  rdistrX,
  param_X,
  n = 10000,
  m_censored = -1,
  theta = 0.5,
  verbose = FALSE,
  right = TRUE
)
}
\arguments{
\item{rdistrX}{sample generator of distribution X. \\ First argument number of samples, next arguments in param_X.}

\item{param_X}{list with parameters of rdistrX function.}

\item{n}{number of sample to create.}

\item{m_censored}{number of sample censored. m_censored < n. \\
If m_censored <= n, m_censored is estimate with the desired censoring percentage.}

\item{theta}{Desired censoring percentage.}

\item{verbose}{if TRUE print a censoring percentage of new created database.}

\item{right}{if TRUE create right-censored data, else create left-censored}
}
\value{
A list with sample data information: \tabular{ll}{
   \code{sample_censored} \tab vector of censored sample \cr
   \tab \cr
   \code{sample_uncensored} \tab vector of uncensored sample (original) \cr
   \tab \cr
   \code{censored_indicator} \tab vector of 1 and 0 indicating whether the i-th sample is censored  \cr
   \tab 1:= no censored, 0:= censored \cr
   \code{censored_time} \tab vector of censorship time \cr
   \code{n_censored} \tab number of censored samples  \cr
}
}
\description{
Generator of censored samples type II with right or left censoring,
 given a generator of samples of the
distribution X (rdistrX) with parameters appended by the list param_X.
 In which, you can control the number of censored sample or the desired censorship percentage.
}
\examples{
##Example Exponential

## Number of sample censored
Data_T2 = rcensT2(rdistrX = rexp, param_X = list("rate" = 2), n = 1e02, m_censored = 9)

## Number of censored sample estimate with desired censoring percentage.
Data_T2 = rcensT2(rdistrX = rexp, param_X = list("rate" = 2), n = 1e02, theta = .8)


## Example with plot in examples_plot/Example_rcensT2_plot.R
}
\seealso{
\code{\link{rcensT1}} for generate censorship sample type I.\cr
\code{\link{rcensT3}} for generate censorship sample type III\cr
\code{\link{rcensI}} for generate interval censoring sample
 with random length interval\cr
\code{\link{rcensIfix}} for generate interval censoring sample
 with fix length interval
}
\author{
Daniel Saavedra Morales
}
