% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.r
\name{store_new_submissions}
\alias{store_new_submissions}
\title{Store new submission files.}
\usage{
store_new_submissions(submissions_dir = "submissions", hist_dir = "history",
  deadline, pattern = ".*\\\\.csv$", valid_fun)
}
\arguments{
\item{submissions_dir}{string. directory of the submissions. contains one subdirectory per team}

\item{hist_dir}{string. directory where to store the history of the submissions. contains one subdirectory per team}

\item{deadline}{POSIXct. deadline time for submissions. The files with last modification date after
the deadline are skipped.}

\item{pattern}{string. regular expression that new submission files must match (with \code{ignore.case=TRUE})}

\item{valid_fun}{function that reads a submission file and throws errors or warnings if
it is not valid.}
}
\value{
\code{store_new_submissions} returns a named list of errors or warnings catched during the process.
  Members named after the team names are lists with members named after the file
  that throws an error which contain the error object.
}
\description{
\code{store_new_submissions} copies new files from the subdirectories of \code{submissions_dir} 
to the respective subdirectories of \code{hist_dir}.
Each team has a subdirectory.
The copied files in \code{hist_dir} are prefixed with the last modification date for uniqueness.
A file is considered new if its name and last modification time is new, i.e not present
in \code{hist_dir}.
The files must match \code{pattern} regular expression and must not
throw errors or warnings when given to the \code{valid_fun} function.
}

