% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcheology.R
\docType{package}
\name{rcheology-package}
\alias{rcheology-package}
\title{Data on base packages from current and previous versions of R}
\description{
rcheology is a data package providing two data frames:
}
\details{
\itemize{
\item \link{rcheology} lists objects in all versions of R from 1.0.1 onwards.
\item \link{Rversions} lists R versions and their release dates. NB: For a more complete
and "canonical" solution, see the
\href{https://cran.r-project.org/package=rversions}{rversions} package.
}

The version of the rcheology package reflects the latest R version to be included in the data,
e.g. 3.5.1.x contains data up to and including R 3.5.1.

An online app for data exploration is available at \url{https://hughjonesd.shinyapps.io/rcheology/}.

\if{html}{\out{
<!-- this is .Rmd so it can be easily included by README.Rmd -->
}}

\subsection{Where the data comes from}{

Versions 4.0.0 and up are installed from the \href{https://cran.r-project.org/bin/linux/ubuntu/bionic-cran40/}{CRAN apt repositories for Ubuntu Bionic}.

Versions 3.0.1 to 3.6.3 are installed from the \href{https://cran.r-project.org/bin/linux/ubuntu/trusty/}{CRAN apt repositories for Ubuntu Trusty Tahr}. Version
3.5.0 and up use a \href{https://cran.r-project.org/bin/linux/ubuntu/trusty-cran35/}{special repository}.

Versions 2.5.1 to 3.0.0 are built from source on \href{https://hub.docker.com/r/yamamuteki/ubuntu-lucid-i386/}{Ubuntu Lucid Lynx}.

Versions 1.2.3 to 2.4.1 are mostly built from source on \href{https://hub.docker.com/r/debian/eol/}{Debian Sarge}.

Versions 1.0.1 to 1.2.2 (and a couple of later versions) are built from
source on \href{https://hub.docker.com/r/debian/eol/}{Debian Woody}.

Results are found from running \code{ls} on all installed packages from a
minimal installation. Recommended packages are not included.

The \code{Rversions} data frame lists versions of R and release dates.
}
}
\section{Limitations}{

\itemize{
\item Functions not built on the relevant platform - e.g. Windows functions - are not included.
\item Because data is collected using the original R version, it is subject to changes in the way
R works. For example, before 2.5.0, \code{\link[=args]{args()}} didn't work on \code{Primitive} functions, so
those functions have no value in the \code{args} column.
\item I have failed to build tcltk on R versions 1.0.1-1.4.1 and 1.7.0/1, so there's no
tcltk data for these versions. If you can help, get in touch.
}
}

