% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxonOneSampleR.r
\name{wilcoxonOneSampleR}
\alias{wilcoxonOneSampleR}
\title{r effect size for Wilcoxon one-sample signed-rank test}
\usage{
wilcoxonOneSampleR(x, mu = NULL, digits = 3, ...)
}
\arguments{
\item{x}{A vector of observations of an ordinal variable.}

\item{mu}{The value to compare \code{x} to, as in \code{wilcox.test}}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{wilcoxsign_test} function.}
}
\value{
A single statistic, r
}
\description{
Calculates r effect size
             for a Wilcoxon one-sample signed-rank test.
}
\details{
A Z value is extracted from the \code{wilcoxsign_test} function in the
          coin package.  r  is calculated as Z divided by 
          square root of the number of observations.
          
          The calculated statistic is equivalent to the statistic returned
          by the \code{wilcoxPairedR} function with one group equal
          to a vector of \code{mu}.
          The author knows of no reference for this technique.
          
          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
}
\examples{
data(Pooh)
Data = Pooh[Pooh$Time==2,]
wilcox.test(Data$Likert, mu=3, exact=FALSE)
wilcoxonOneSampleR(x = Data$Likert, mu=3)

}
\references{
\url{http://rcompanion.org/handbook/F_02.html}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{
effect size ordinal nominal
}
