
/* 	$Id $	 */


//#include <malloc.h>
#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "conifers.h"



/****************************************************************************/
/* stand management coop variant coeffs                                     */
/****************************************************************************/

/* todo: add/update version number for your model's coefficients  */
#define N_SMC_CONIFERS_COEFFS      3
#define SMC_COEFFS_VERSION      1.00
#define SMC_MODEL_VERSION       1.00


/* this structure MUST be the EXACT same structure def as the one defined in the header file */
struct CON_SMC_COEFFS_RECORD 
   {
    unsigned long   idx;        /* this is the functional species code -- group in 2.0 */
    unsigned long   type;       /* 0, 1, 2, or 3 */

    /* this is required for the user interface */
	 char    group[SP_LENGTH];               /*  name abbreviated from the usfs  */

	 double  d6_growth[MAX_COEFFS];          /* 1  D3: growth coeffs               */
	 double  ht_growth[MAX_COEFFS];          /* 2  D1: growth coeffs               */ 
	 double  cr_growth[MAX_COEFFS];          /* 3  D4: hcb change parameters       */
	 double  crown_ratio[MAX_COEFFS];        /* 4  S3: crown ratio coeffs          */
	 double  crown_width[MAX_COEFFS];        /* 5  S1: crown width coeffs, old CA  */
	 double  max_crown_width[MAX_COEFFS];    /* 6  S2: crown width coeffs, old CA  */
	 double  d6_ht_dbh[MAX_COEFFS];          /* 7  S5, S7                          */
	 double  d6_ht[MAX_COEFFS];              /* 8  S4, S9                          */
	 double  dbh_ht[MAX_COEFFS];             /* 9  S6, S10                         */
	 double  n_stems_from_ht[MAX_COEFFS];    /* 10 S11                             */
	 double  dbh_growth[MAX_COEFFS];         /* 11 D2: dbh growth coefficients     */
	 double  cfvolume4[MAX_COEFFS];          /* 12 S12 volume coefficients         */
	 double  biomass[MAX_COEFFS];            /* 13 S13 biomass coefficients        */
	 double  cw_growth[MAX_COEFFS];          /* 14 d6 cw_growth coefficients        */

	 /* coefficients added for the CIPS variant */
	 /* todo: you need to added these the old models too */
	 double  dbh_ht_veg_cov[MAX_COEFFS];	
	 double	 d6_ht_veg_cov[MAX_COEFFS];	
	 double	 d12_ht_veg_cov[MAX_COEFFS];
	 double	 mortality[MAX_COEFFS];



} static smc_temp_coeffs[N_SMC_CONIFERS_COEFFS] = {

/* height grow coeffs input on nov 15, 2007 using Nicks updated coeffs for DF */
/* dbh grow coeffs input on nov 15, 2007 using Nicks updated coeffs for DF    */

/*                         0         1         2          3         4         5         6        7         8          9         10        11       12       13        14       15        */
{ /* index 0, FBR type = 2 , this is the default for brush */
0, SHRUB, "FBR",
/* d6_growth        */{ 0.052777, 0.046057, 0.000000, 0.091103, 0.004174, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* ht_growth        */{ 0.376316,-3.461019, 1.677419,-0.099159,-0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* cr_growth        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* crown_ratio      */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* crown_width      */{ 0.702099, 0.617866, 1.325870, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* max_crown_width  */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d6_ht_dbh        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d6_ht            */{-0.958757, 0.536006, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* dbh_ht           */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* n_stems_from_ht  */{ 0.528185, 0.891697,-0.067543,-0.121772, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* dbh_growth       */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* cfvolume4        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* biomass          */{-6.909900, 2.854200, 0.078000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* cw_growth        */{ 0.460500,-0.294900,-0.402800, 0.000000, 0.000000, 0.000000, 0.000000, 0.100000, 0.949400,-0.562100,-1.101110, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* dbh_ht_veg_cov   */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d6_ht_veg_cov    */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d12_ht_veg_cov   */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* mortality        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*                         0         1         2          3         4         5         6        7         8          9         10        11       12       13        14       15        */
{ /* index 1, FDF type = 0 */
1, CONIFER, "FDF",
/* d6_growth        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* ht_growth        */{ 0.000000, -0.278236, 1.500000, 1272.476, 2.710962, 0.040230,-2.487061,-0.123726,-0.673017, 29.41825,-0.984903, 0.344320,  -0.1839,  -0.2326,  0.50976,     0.00},
/* cr_growth        */{ 0.170720,  0.080100, 0.259900, 0.319770, 0.085170, 3.465700,-1.787900,-0.696800,-0.644600,-0.644600,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* crown_ratio      */{ 0.708783,  0.997520,     0.00, 0.812272,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* crown_width      */{ 0.335198,  0.494185, 1.227520,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* max_crown_width  */{ 4.636600,  1.607800,-0.009625,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* d6_ht_dbh        */{ 0.778122,  0.666671, 0.174612,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* d6_ht            */{-1.375748,  1.016819,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* dbh_ht           */{ 7.127600, -5.364200,-0.261749,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* n_stems_from_ht  */{     0.00,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* dbh_growth       */{     0.00,  4.023454, 1.216498, 0.092755,-0.006679,      0.0,-0.094167,-0.028059, 1.882094, 0.020688,-0.673017, 29.41825, -0.00035,      0.0,      0.0, 0.000000},
/* cfvolume4        */{ 0.002244,  1.943420, 0.996400, 0.999200,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* biomass          */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,-2.846200, 1.700900,-3.694100,  2.13820, -3.03960, 2.595100,      0.0,      0.0,      0.0, 0.000000},
/* cw_growth        */{ 0.860817,  0.957470,-0.164190,      0.0,-0.098730,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
/* dbh_ht_veg_cov   */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d6_ht_veg_cov    */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d12_ht_veg_cov   */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* mortality        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*                         0         1         2          3         4         5         6        7         8          9         10        11       12       13        14       15        */
{ /* index 16, FNS type = 4 */
2, NON_STOCKED, "FNS",
/* d6_growth        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* ht_growth        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* cr_growth        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* crown_ratio      */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* crown_width      */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* max_crown_width  */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d6_ht_dbh        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d6_ht            */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* dbh_ht           */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* n_stems_from_ht  */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* dbh_growth       */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* cfvolume4        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* biomass          */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* cw_growth        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* dbh_ht_veg_cov   */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d6_ht_veg_cov    */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* d12_ht_veg_cov   */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
/* mortality        */{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
}

};


/* this function allocates an array of n_coeffs records     */
/* which is the array that will be returned. the function   */
/* then copies the local coeffs into that array and the     */
/* returns                                                  */
struct COEFFS_RECORD *con_smc_init_coeffs( 
   unsigned long               *n_coeffs, 
   double                       *coeffs_version,
   double                       *model_version )
{

    struct COEFFS_RECORD *temp_coeffs; 

    /* todo: make sure the size of the coefficient records match */
    if( sizeof( struct COEFFS_RECORD ) == sizeof( struct CON_SMC_COEFFS_RECORD ) )
    {
        /* these are defined by the model */
        *n_coeffs       = N_SMC_CONIFERS_COEFFS;
        *coeffs_version = (double)SMC_COEFFS_VERSION;
        *model_version = (double)SMC_MODEL_VERSION;

        temp_coeffs = (struct COEFFS_RECORD *)calloc( 
            *n_coeffs, sizeof( struct COEFFS_RECORD ) );

        memcpy( temp_coeffs, smc_temp_coeffs, sizeof( smc_temp_coeffs ) );
    }
    else
    {
        *n_coeffs       = 0;
        *coeffs_version = 0.0;
        *model_version  = 0.0;
        return NULL;
    }

   return temp_coeffs;
}


