% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_bbox}
\alias{as_bbox}
\title{Get the bounding box from the x object}
\usage{
as_bbox(x)
}
\arguments{
\item{x}{Simple feature object (or compatible) or a bounding box, provided
either as a matrix (with x, y as rows and min, max as columns) or as a
vector (xmin, ymin, xmax, ymax)}
}
\value{
A \code{bbox} object as returned by \code{\link[sf:st_bbox]{sf::st_bbox()}}
}
\description{
If the x does not have a CRS, WGS84 is assumed.
}
\examples{
library(sf)
bounding_coords <- c(25.9, 44.3, 26.2, 44.5)
bb <- as_bbox(bounding_coords)
class(bb)
st_crs(bb)
}
