% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pmid2doi.R
\name{pmid2doi}
\alias{doi2pmid}
\alias{pmid2doi}
\title{Get a PMID from a DOI, and vice versa.}
\usage{
pmid2doi(x, simplify = FALSE, ...)

doi2pmid(x, simplify = FALSE, ...)
}
\arguments{
\item{x}{(character) One or more DOIs or PMIDs}

\item{simplify}{(logical) Whether to simplify result to vector.}

\item{...}{Curl args passed on to \code{\link[httr]{GET}}.}
}
\description{
Get a PMID from a DOI, and vice versa.
}
\examples{
\dontrun{
# get a pmid from a doi
# doi2pmid("10.1016/0006-2944(75)90147-7")

# More examples
## dois to pmids
# doi2pmid("10.1016/0006-2944(75)90147-7", TRUE)
# doi2pmid(c("10.1016/0006-2944(75)90147-7","10.1186/gb-2008-9-5-r89"))

## pmids to dois
# pmid2doi(18507872)
# pmid2doi(18507872, TRUE)
# pmid2doi(c(1,2,3))

## pass in curl options
# library('httr')
# pmid2doi(18507872, config=verbose())
}
}
\references{
Uses the http://www.pmid2doi.org/ REST API. Its currently unavailable.
}

