% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdataretriever.R
\name{install_sqlite}
\alias{install_sqlite}
\title{Install datasets via the Data Retriever.}
\usage{
install_sqlite(dataset, file = "sqlite.db",
  table_name = "{db}_{table}", data_dir = getwd(), debug = FALSE,
  use_cache = TRUE)
}
\arguments{
\item{dataset}{the name of the dataset that you wish to install}

\item{file}{Sqlite database file name or path}

\item{table_name}{table name for installing of dataset}

\item{data_dir}{the dir path to store the db, defaults to working dir}

\item{debug}{Setting TRUE helps in debugging in case of errors}

\item{use_cache}{Setting FALSE reinstalls scripts even if they are already installed}
}
\description{
Data is stored in SQLite database
}
\examples{
\donttest{
rdataretriever::install_sqlite(dataset='iris', file='sqlite.db', debug=FALSE, use_cache=TRUE)
}
}
