% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_geoBndBox}
\alias{ddi_geoBndBox}
\alias{ddi_eastBL}
\alias{ddi_northBL}
\alias{ddi_southBL}
\alias{ddi_westBL}
\title{geoBndBox and its child nodes}
\usage{
ddi_geoBndBox(...)

ddi_eastBL(...)

ddi_northBL(...)

ddi_southBL(...)

ddi_westBL(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
The fundamental geometric description for any dataset that models geography.
GeoBndBox is the minimum box, defined by west and east longitudes and north
and south latitudes, that includes the largest geographic extent of the
dataset's geographic coverage. This element is used in the first pass of a
coordinate-based search. If the boundPoly element is included, then the
geoBndBox element MUST be included. More information on these elements,
especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{geoBndBox} is contained in \code{sumDscr}.

\emph{geoBndBox specific child nodes}
\itemize{
\item \code{ddi_eastBL()} is the easternmost coordinate delimiting the geographic
extent of the dataset. A valid range of values, expressed in decimal degrees
(positive east and positive north), is: -180,0 <= East Bounding Longitude
Value <= 180,0.
\item \code{ddi_northBL()} is the northernmost coordinate delimiting the geographic
extent of the dataset. A valid range of values, expressed in decimal degrees
(positive east and positive north), is: -90,0 <= North Bounding Latitude
Value <= 90,0 ; North Bounding Latitude Value >= South Bounding Latitude
Value.
\item \code{ddi_southBL()} is the southernmost coordinate delimiting the geographic
extent of the dataset. A valid range of values, expressed in decimal degrees
(positive east and positive north), is: -90,0 <=South Bounding Latitude
Value <= 90,0 ; South Bounding Latitude Value <= North Bounding Latitude
Value.
\item \code{ddi_westBL()} is the westernmost coordinate delimiting the geographic
extent of the dataset. A valid range of values, expressed in decimal degrees
(positive east and positive north), is: -180,0 <=West Bounding Longitude
Value <= 180,0.
}
}
\examples{
ddi_geoBndBox()

# Functions that need to be wrapped in ddi_geoBndBox()

ddi_eastBL("90")

ddi_northBL("17")

ddi_southBL("45")

ddi_westBL("-10")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/geoBndBox.html}{geoBndBox documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/eastBL.html}{eastBL documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/northBL.html}{northBL documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/southBL.html}{southBL documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/westBL.html}{westBL documentation}
}
