% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaseRateService.R
\name{dfp_createBaseRates}
\alias{dfp_createBaseRates}
\title{BaseRateService}
\usage{
dfp_createBaseRates(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createBaseRatesResponse
}
\description{
Provides methods for managing BaseRate objects.
To use this service, you
need to have the new sales management solution enabled on your network. If
you do not see a "Sales" tab in
\href{https://www.google.com/dfp}{DoubleClick for Publishers (DFP)}, you
will not be able to use this service.
}
\details{
createBaseRates

Creates a list of new BaseRate objects.
}
\examples{
\dontrun{
 res <- dfp_createBaseRates(request_data)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/BaseRateService#createBaseRates}{Google Documentation for createBaseRates}
}
