% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/content.R
\name{guardian_content}
\alias{guardian_content}
\title{Search Guardian Content}
\usage{
guardian_content(api_key, query, from = NULL, to = NULL, section = NULL,
  reference = NULL, reference_type = NULL, tags = NULL, rights = NULL,
  ids = NULL, production_office = NULL, page = NULL, page_size = 50,
  fields = NULL, collapse = TRUE, ...)
}
\arguments{
\item{api_key}{A key to the Guardian API, which can be obtained
\href{http://open-platform.theguardian.com/access/}{here}.}

\item{query}{Your search query. This can contain operators (\code{sausage AND mash}) or
phrases (\code{"sausage & mash"}); by default, searches work as an OR, looking for
the presence of any one individual word in the query.}

\item{from}{the date to limit by. If set, the search will only cover data written after this date.
Optional (NULL) by default. Can be set in conjunction with \code{to}.}

\item{to}{Another date to limit by. If set, the search will only cover data written before this date.
Optional (NULL) by default. Can be set in conjunction with \code{from}.}

\item{section}{the section, or sections, of \emph{The Guardian} that you want to limit the search to. Multiple
sections may be concatenated together using boolean operators; see \code{\link{guardian_and}} and \code{\link{guardian_or}}.}

\item{reference}{the references to limit the search to; only articles that include those references (and meet other
conditions) will be returned. Also accepts boolean operators.}

\item{reference_type}{the type of reference (such as \code{isbn}). Also accepts boolean operators.}

\item{tags}{the tags to limit the search to; only articles that contain these tags will be returned. Also accepts
boolean operators.}

\item{rights}{limit a search to content with these rights (syndicatable content, for example). Options are
\code{syndicatable} and \code{subscription-database}. Does not accept boolean operators.}

\item{ids}{limit a search to content with these IDs, an ID being the standard URL fragment after \code{guardian.com} (
or \code{co.uk}, or...). Does not accept boolean operators.}

\item{production_office}{the production office(s) to limit to, such as "aus". Accepts boolean operators.}

\item{page}{a particular page of results to return. Useful when returning multiple sets of data with the same query;
you can repeat the query, incrementing the value in \code{page}.}

\item{page_size}{the maximum number of items to return; anywhere between 1 and 50. Set to 50 by default.}

\item{fields}{additional fields to include in the returned data (when available). Possible values
(which should appear in a vector) appear \href{http://open-platform.theguardian.com/documentation/search}{here}.}

\item{collapse}{whether to collapse the actual content into a data.frame. Set to TRUE by default.}

\item{...}{further arguments to pass to httr's \code{GET}.}
}
\description{
\code{guardian_content} lets you directly search
The Guardian for content, including support for conditional
searches, date-range based filtering, and section or tag
based filtering.
}
\examples{
# Simple example

result <- guardian_content("test", "debate AND economy")
}
\seealso{
\code{\link{guardian_tags}} to retrieve metadata about tags.
}

