% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repartition.R
\name{repartition}
\alias{repartition}
\title{Repartition metacommunity}
\usage{
repartition(meta, new_partition)
}
\arguments{
\item{meta}{object of class \code{metacommunity}.}

\item{new_partition}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types (species), columns as subcommunities, and each
element containing the relative abundance of types in each subcommunity
relative to the metacommunity as a whole. In the phylogenetic case, this
corresponds to the proportional abundance of terminal taxa. If this argument
is missing, all species / tips will be shuffled}
}
\value{
\code{repartition()} returns an object of class \code{metacommunity}
}
\description{
Randomly reshuffles the relative abundance of types (\emph{e.g}. species) in
a metacommunity (whilst maintaining the relationship between the relative
abundance of a particular species across subcommunities). In the case of a
phylogenetic metacommunity, the relative abundance of terminal taxa are
randomly reshuffled and the relative abundance of types (historical species)
are calculated from the resulting partition.
}
