% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{dracor_api}
\alias{dracor_api}
\title{Send a GET request to DraCor API and parse the results}
\usage{
dracor_api(
  request,
  expected_type = c("application/json", "application/xml", "text/csv", "text/plain"),
  parse = TRUE,
  default_type = FALSE,
  split_text = TRUE,
  as_tibble = TRUE,
  ...
)
}
\arguments{
\item{request}{Character, valid GET request.}

\item{expected_type}{Character, 'MIME' type: one of
\code{"application/json"},  \code{"application/xml"}, \code{"text/csv"},
\code{"text/plain"}.}

\item{parse}{Logical, if \code{TRUE} (default value), then a response is
parsed depending on \code{expected_type}. See details below.}

\item{default_type}{Logical, if \code{TRUE}, default response data type is
returned. Therefore, a response is not parsed and \code{parse} is ignored.
The default value is \code{FALSE}.}

\item{split_text}{Logical, if \code{TRUE}, plain text lines are read as
different values in a vector instead of returning one character value.
Default value is \code{TRUE}.}

\item{as_tibble}{Logical, if \code{TRUE}, data frame will be returned as a
tidyverse tibble (\code{tbl_df}). The default value is \code{TRUE}.}

\item{...}{Other arguments passed to a parser function.}
}
\value{
A content of a response to GET method to the 'DraCor' API. If
\code{parse = FALSE} or \code{default_type = TRUE}, a single character value
is returned. Otherwise, the resulting value is parsed according to a value of
\code{default_type} parameter. The resulting structure of the output depends
on the selected \code{default_type} value, the respective function for
parsing (see \code{default_type}) and additional parameters that are passed
to the function for parsing.
}
\description{
Function \code{dracor_api()} sends a GET request to DraCor API with a
specified expected type and parses results depending on selected expected
type.
}
\details{
There are four different 'MIME' types (aka internet media type) that can be
retrieved for DraCor API, the specific combination of possible 'MIME' types
depends on API command. When \code{parse = TRUE} is used, the content is
parsed depending on selected 'MIME' type in \code{expected_type}:
\describe{
  \item{\code{application/json}}{\code{
  \link[jsonlite:fromJSON]{jsonlite::fromJSON()}}}
  \item{\code{application/xml}}{\code{\link[xml2:read_xml]{xml2::read_xml()}}}
  \item{\code{text/csv}}{\code{\link[data.table:fread]{data.table::fread()}}}
  \item{\code{text/plain}}{No need for additional preprocessing}}
}
\examples{
dracor_api("https://dracor.org/api/info", expected_type = "application/json")
}
\seealso{
\code{\link{dracor_sparql}}
}
