% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-causal-forests.R
\name{causal_forest_handler}
\alias{causal_forest_handler}
\title{Tidy helper function for causal_forest function}
\usage{
causal_forest_handler(data, covariate_names, share_train = 0.5, ...)
}
\arguments{
\item{data}{A data.frame}

\item{covariate_names}{Names of covariates}

\item{share_train}{Share of units to be used for training}

\item{...}{Options to causal_forest}
}
\value{
a data.frame of estimates
}
\description{
Runs estimates estimation function from interference package and returns tidy data frame output
}
\details{
https://draft.declaredesign.org/complex-designs.html#discovery-using-causal-forests

See ?causal_forest for further details
}
\examples{

library(DeclareDesign)
library(ggplot2)

dat <- fabricate(
   N = 1000,
   A = rnorm(N),
   B = rnorm(N),
   Z = complete_rs(N),
   Y = A*Z + rnorm(N))

# note: remove num.threads = 1 to use more processors
estimates <- causal_forest_handler(data = dat, covariate_names = c("A", "B"), num.threads = 1)

ggplot(data = estimates, aes(A, pred)) + geom_point()

}
