% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newColumnNames.R
\name{newColumnNames}
\alias{newColumnNames}
\title{Enhance readDWD column names}
\usage{
newColumnNames(dataframe, variables = dwdparams, separator = ".")
}
\arguments{
\item{dataframe}{Dataframe as returned by \code{\link[=readDWD.data]{readDWD.data()}}}

\item{variables}{Dataframe as returned by \code{\link[=readVars]{readVars()}} for a
single file. Rownames must be variable abbreviations.
There must be a "Kurz" column.
DEFAULT: \code{\link{dwdparams}}}

\item{separator}{Separator between abbreviation and long name. DEFAULT: "."}
}
\value{
The \code{dataframe} with new column names
}
\description{
Add short German parameter descriptions to the DWD abbreviations.
This uses \code{\link[=dwdparams]{dwdparams()}} to create column names like
"TT_TU.Lufttemperatur" and "RSK.Niederschlagshoehe."
Column names not in the abbreviation list will be left untouched.
}
\examples{
# mainly for internal usage

}
\seealso{
\code{\link{dwdparams}}, \code{\link[=readVars]{readVars()}},  \code{\link[=readDWD]{readDWD()}} argument \code{varnames}, \code{\link[=newColumnNames]{newColumnNames()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr 2019
}
