% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_bars_gradient.R
\name{data_bars_gradient}
\alias{data_bars_gradient}
\title{Add horizontal gradient bars to rows in a column}
\usage{
data_bars_gradient(
  data,
  colors = c("#1efffd", "#1e20ff"),
  background = "white",
  number_fmt = NULL
)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{colors}{A vector of colors of at least two colors.
Colors should be given in order from left to right as shown on the data bar.
Default colors are c("#1efffd", "#1e20ff").}

\item{background}{Optionally assign a color to use as the background for cells.
Default is set to white.}

\item{number_fmt}{Optionally format numbers using formats from the scales package.
Default is set to NULL.}
}
\value{
a function that applies data bars
    to a column of numeric values.
}
\description{
The `data_bars_gradient()` function conditionally adds a left-to-right linear gradient to each row of a column.
    The length of the bars are relative to the value of the row in relation to other values within the same column.
    It should be placed within the cell argument in reactable::colDef.
}
\examples{
library(reactable)
data <- MASS::Cars93[20:49, c("Make", "MPG.city", "MPG.highway")]

## By default, colors are provided
reactable(data,
defaultColDef = colDef(
align = "left",
cell = data_bars_gradient(data)))

## Apply custom colors for gradient
reactable(data,
defaultColDef = colDef(
align = "left",
cell = data_bars_gradient(data, colors = c("white","grey","black"))))

## Apply bacground color
reactable(data,
defaultColDef = colDef(
align = "left",
cell = data_bars_gradient(data, background = "black")))

## Use number_fmt to format numbers using the scales package
car_prices <- MASS::Cars93[20:49, c("Make", "Price")]

reactable(car_prices,
defaultColDef = colDef(cell = data_bars_gradient(car_prices,
number_fmt = scales::dollar_format(accuracy = 0.1))))

}
