% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{flatly}
\alias{flatly}
\title{Theme flatly}
\usage{
flatly(
  font_family = "Georgia",
  font_size = 14,
  font_color = "#212529",
  header_font_family = "Georgia",
  header_font_size = 15,
  header_font_color = "#ffffff",
  cell_padding = 6
)
}
\arguments{
\item{font_family}{Font family for the text within the table.
Default is Georgia.}

\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 14.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #212529.}

\item{header_font_family}{Font family for the header text.
Default is Georgia.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is #ffffff.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Bootstrap-inspired flatly theme
}
\examples{
data <- iris[10:29, ]

## Standard flatly theme
reactable(data,
          theme = flatly())

## Cerulean theme with additional options applied
reactable(data,
          theme = flatly(font_size = 12, font_color = "grey", cell_padding = 3))

}
