% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{rws_read_table}
\alias{rws_read_table}
\alias{rws_read_sqlite_table}
\title{Read a Table from a SQLite Database}
\usage{
rws_read_table(x, meta = TRUE, conn)
}
\arguments{
\item{x}{A string of the table name.}

\item{meta}{A flag specifying whether to preserve meta data.}

\item{conn}{A \linkS4class{SQLiteConnection} to a database.}
}
\value{
A data frame of the table.
}
\description{
Read a Table from a SQLite Database
}
\examples{
conn <- rws_connect()
rws_write(rws_data, exists = FALSE, conn = conn)
rws_write(rws_data[c("date", "ordered")],
  x_name = "data2", exists = FALSE, conn = conn
)
rws_read_table("data2", conn = conn)
rws_disconnect(conn)
}
