% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permanova.R
\name{permanova}
\alias{permanova}
\title{PERMANOVA with flexible permutation control}
\usage{
permanova(
  X,
  sample_data,
  formula_rhs,
  dist_control = list(method = "euclidean", diag = FALSE, upper = FALSE),
  perm_control = list(joint_terms = list(control = permute::how(blocks = NULL, nperm =
    999))),
  independent = TRUE,
  platform = c("ms", "nmr", "ngs"),
  assay = NULL,
  seed = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{X}{A processed matrix or data frame of features (samples in rows, features in columns).}

\item{sample_data}{A \code{data.frame} containing sample-level data.
Row names must match those in \code{X}.}

\item{formula_rhs}{A one-sided formula (e.g., \code{~ group + age}).}

\item{dist_control}{A named list of arguments to control distance calculation.
Must contain at least \code{method}. Defaults to \code{"Euclidean"} via \code{stats::dist()}.}

\item{perm_control}{A named list specifying \code{permute::shuffleSet()} parameters.
By default, \code{joint_terms} parameters will be used, with same \code{vegan::adonis2()}
defaults, unless variable-specific permutation settings are added as named list
elements (e.g. perm_control = list(joint_terms = , age = , sex = )).}

\item{independent}{Logical. If \code{TRUE}, a PERMANOVA test for each variable in \code{formula_rhs} is performed.}

\item{platform}{A string specifying the omics platform (\code{"ms"}, \code{"nmr"}, \code{"ngs"}). Used for annotation.}

\item{assay}{Optional. Character string giving the assay name for annotation (e.g., \code{"lipidomics"}).}

\item{seed}{Optional integer. If provided, sets the random seed for reproducible permutation results.}

\item{verbose}{Logical. If \code{TRUE}, prints diagnostic messages.}

\item{...}{Additional arguments passed to \code{vegan::adonis2()}.}
}
\value{
A named \code{list} with three elements:
\describe{
\item{X_dist}{A \code{dist} object.}
\item{perm_matrix_joint}{A \code{matrix} from \code{permute::shuffleSet()} joint_terms control.}
\item{permanova_joint}{A \code{data.frame} of PERMANOVA results using the full model.}
\item{permanova_indep}{A \code{data.frame} of a PERMANOVA results for each predictor,
or \code{NULL} if \code{independent = FALSE}.}
}
}
\description{
Performs PERMANOVA (Permutational Multivariate Analysis of Variance).
Supports both joint-term (default \code{vegan::adonis2()}) and single-term testing
when \code{independent = TRUE}.
Several distance methods, and fine-grained permutation control.
}
\details{
\itemize{
\item Supports both \code{stats::dist()} and \code{vegan::vegdist()} for distance matrix computation.
\item Distance method must be specified in \code{dist_control$method}.
\item Permutation design is controlled via the permute package using \code{permute::shuffleSet()}.
\item If \code{seed} is supplied, the same permutations will be used across runs for reproducibility.
}
}
\examples{
# Mock data
X <- matrix(rnorm(40), nrow = 10,
            dimnames = list(paste0("sample", 1:10),
                            paste0("feat", 1:4)))
sample_data <- data.frame(
  sample_id = rownames(X),
  group = factor(rep(c("A", "B"), each = 5)),
  age = rep(20:29, length.out = 10),
  row.names = rownames(X),
  stringsAsFactors = FALSE
)

# Simple control structures
dist_control <- list(method = "euclidean")
perm_control <- list(
  joint_terms = list(control = permute::how(blocks = NULL, nperm = 9)),
  group = list(control = permute::how(blocks = NULL, nperm = 9)),
  age = list(control = permute::how(blocks = NULL, nperm = 9))
)

result <- permanova(
  X = X,
  sample_data = sample_data,
  formula_rhs = ~ group + age,
  dist_control = dist_control,
  perm_control = perm_control,
  independent = TRUE,
  platform = "ms",
  assay = "lipidomics",
  seed = 42,
  verbose = FALSE
)

}
\seealso{
\itemize{
\item \code{\link[stats:dist]{stats::dist()}} and \code{\link[vegan:vegdist]{vegan::vegdist()}} for information on available distances.
\item \code{\link[vegan:adonis]{vegan::adonis2()}} and \code{\link[permute:shuffleSet]{permute::shuffleSet()}} for control options and details.
\item \code{\link[=process_ngs]{process_ngs()}} to pre-process and normalize an \code{X} NGS dataset.
\item \code{\link[=process_ms]{process_ms()}} to pre-process and normalize an \code{X} MS dataset.
}
}
