% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matches.R
\name{match_fn}
\alias{match_fn}
\title{Compares proportions of matching summary statistics within two-arm randomised trials}
\usage{
match_fn(df = match_data, verbose = TRUE)
}
\arguments{
\item{df}{data frame generated from load_clean function}

\item{verbose}{TRUE or FALSE indicates whether to print flextable}
}
\value{
list containing 6 objects as described
\itemize{
\item match_ft_all = flextable of matches with reference data
\item match_ft = flextable of matches (no reference data)
\item ref_match_ft = flextable of reference data
\item match_match_data = data frame of results used in calculations
\item match_table = data frame of matches used to make flextable
\item ref_table = data frame of reference data used to make flextable
}
}
\description{
Creates flextable of matching summary statistics by significant figures with Reference data\cr
}
\details{
Reference data is from Bolland 2021\cr
Bolland MJ, Gamble GD, Avenell A, Grey A. Identical summary statistics were uncommon in randomized trials and cohort studies. J Clin Epidemiol 2021;136:180-188.

Returns a list containing 6 objects and (if verbose = TRUE ) prints the flextable match_ft_all
}
\examples{
# load example data
match_data <- load_clean(import= "no", file.cont = "SI_pvals_cont", match= "yes",
format.cont = "wide")$match_data

\donttest{
# run function (takes only a few seconds)
match_fn()$match_ft_all

# to import an excel spreadsheet (modify using local path,
# file and sheet name, range, and format):

# get path for example files
path <- system.file("extdata", "reappraised_examples.xlsx", package = "reappraised",
                    mustWork = TRUE)
# delete file name from path
path <- sub("/[^/]+$", "", path)

# load data
match_data <- load_clean(import= "yes", match = "yes", dir = path,
     file.name.cont = "reappraised_examples.xlsx", sheet.name.cont = "SI_pvals_cont",
     range.name.cont = "A:O", format.cont = "wide")$match_data}

}
