% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_rand.R
\name{sr_fn}
\alias{sr_fn}
\title{Compares observed and expected distribution of difference in numbers of participants between groups in two-arm randomised trials}
\usage{
sr_fn(
  df = sr_data,
  br = "no",
  block = data.frame(study = "", fbsz = "", n_fb = "", df = ""),
  title = "",
  verbose = TRUE
)
}
\arguments{
\item{df}{data frame generated from load_clean function}

\item{br}{block randomisation: 'yes' or 'no'. If 'no' runs function as if all trials used simple randomisation. If 'yes' performs simple calculations as if block randomised}

\item{block}{an additional option for studies using block randomisation. block is a data frame containing columns named study (for study id); fbsz (for the final block size); n_fb (for number of participants in the final block); df (the difference between groups)}

\item{title}{title name for plots (optional)}

\item{verbose}{TRUE or FALSE indicates whether progress bar and comments in block randomisation function show and whether to print plot}
}
\value{
list containing 4 objects as described

\itemize{
\item sr_graph = plot of observed to expected numbers for differences between numbers of participants in trial groups
\item sr_graph = plot of observed to expected numbers and ratios for differences between numbers of participants in trial groups
\item sr_individual_graphs = list containing 2 plots making up composite figure
\item sr_data = data frame containing data for plots
}
}
\description{
Creates plot of observed to expected numbers and ratios for differences in numbers of participants between trial groups\cr
}
\details{
An example is for Sato and Iwamoto trials in Bolland 2016\cr
Bolland MJ, Avenell A, Gamble GD, Grey A. Systematic review and statistical analysis of the integrity of 33 randomized controlled trials. Neurology 2016;87:2391-2402.

Returns a list containing 4 objects and (if verbose = TRUE) prints the plot sr_graph
}
\examples{
# load example data
sr_data <- load_clean(import= "no", file.cat = "SI_cat", sr= "yes",
format.cat = "wide")$sr_data

\donttest{
# run function (takes only a few seconds)
sr_fn()$sr_graph

# to import an excel spreadsheet (modify using local path,
# file and sheet name, range, and format):

# get path for example files
path <- system.file("extdata", "reappraised_examples.xlsx", package = "reappraised",
                    mustWork = TRUE)
# delete file name from path
path <- sub("/[^/]+$", "", path)

# load data
sr_data <- load_clean(import= "yes", sr = "yes", dir = path,
   file.name.cat = "reappraised_examples.xlsx", sheet.name.cat = "SI_cat",
   range.name.cat = "A:D", format.cat = "wide")$sr_data

# function has an additional option for block randomisation.
#  If studies are block randomised and the final block size is known,
#  the number of participants in the final block can be determined.
#  The distribution of differences between groups for the final block
#  can be compared to the expected distribution
#
#  Few studies provide all these details so it seems unlikely this function
#  would get used often

# Example takes only a few seconds to run

sr_fn(br = "yes", block = data.frame(study = c(1,2,3,4,5,6,7,8,9,10),
         fb_sz= c(2,4,6,8,10,12,8,8,6,14), n_fb = c(1,1,4,5,7,8,4,6,2,10),
         df=c(1,1,0,1,3,4,2,2,0,0)))$sr_graph}

}
