% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdregioncheck.R
\name{ebirdregioncheck}
\alias{ebirdregioncheck}
\title{Check if a region type is valid}
\usage{
ebirdregioncheck(loctype, loc, ...)
}
\arguments{
\item{loctype}{One of: 'country', 'states', 'counties'}

\item{loc}{The location code to be checked. A single location only,
unless \code{loctype = 'country'}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A logical vector of the same length as \code{loc}.
}
\description{
Check if a region type is valid
}
\examples{
\dontrun{
ebirdregioncheck("country", c("US", "CA"))
ebirdregioncheck("states", "CA-BC")
ebirdregioncheck("counties","CA-BC-GV")
}
}
\references{
\url{http://ebird.org/}
}
\author{
Sebastian Pardo \email{sebpardo@gmail.com},
   Andy Teucher \email{andy.teucher@gmail.com}
}
