% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdchecklistfeed.R
\name{ebirdchecklistfeed}
\alias{ebirdchecklistfeed}
\title{Checklist feed on a date at a region or hotspot}
\usage{
ebirdchecklistfeed(loc, date, max = 10, sleep = 0, key = NULL, ...)
}
\arguments{
\item{loc}{(required) Region code or locID (if a hotspot). Region code can
be country code (e.g. "US"), subnational1 code (states/provinces, e.g. "US-NV"), or
subnational2 code (counties, e.g. "US-VA-003").}

\item{date}{(required) Date of historic observation date formatted according 
to ISO 8601 (e.g. 'YYYY-MM-DD', or 'YYYY-MM-DD hh:mm'). Hours and minutes 
are excluded.}

\item{max}{Maximum number of result rows to return in this request (between 1 and 200, default 10)}

\item{sleep}{Time (in seconds) before function sends API call. The defaults is
zero. Set this to a higher number if you are using this function in a loop with
many API calls.}

\item{key}{eBird API key. You can obtain one from https://ebird.org/api/keygen.
We strongly recommend storing it in your \code{.Renviron} file as an 
environment variable called \code{EBIRD_KEY}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}.}
}
\value{
A data.frame containing the collected information:

"locId": unique identifier for the locations

"subId": submission (checklist) identifier

"userDisplayName": first and last name of the observer

"numSpecies": number of species reported

"obsDt": observation date formatted according to ISO 8601 
   (e.g. 'YYYY-MM-DD', or 'YYYY-MM-DD hh:mm'). Hours and minutes are excluded 
   if the observer did not report an observation time

"obsTime": observation time (24hr)

"subID": deprecated submission identifier

"loc": delimited string of location descriptors
}
\description{
Returns checklist-level information reported in a given region or hotspot. Note only bird
information is species count.
}
\examples{
\dontrun{
ebirdchecklistfeed(loc = "L207391", date = "2020-03-24", max = 10)
}
}
\references{
\url{http://ebird.org/}
}
\author{
Marianna Foos \email{marianna.foos@gmail.com}
}
