% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified.R
\name{cistrat}
\alias{cistrat}
\title{Confidence Intervals for the Stratified Estimator}
\usage{
cistrat(
  n1,
  n2,
  m2,
  conf = 0.95,
  method = "both",
  bootreps = 10000,
  estimator = "Chapman",
  useChapvar = FALSE
)
}
\arguments{
\item{n1}{Number of individuals captured and marked in the first sample}

\item{n2}{Number of individuals captured in the second sample}

\item{m2}{Number of marked individuals recaptured in the second sample}

\item{conf}{The confidence level of the desired intervals.  Defaults to 0.95.}

\item{method}{Which method of confidence interval to return.  Allowed values
are \code{"norm"}, \code{"boot"}, or \code{"both"}.  Defaults to
\code{"both"}.}

\item{bootreps}{Number of bootstrap replicates to use.  Defaults to 10000.}

\item{estimator}{The type of estimator to use.  Allowed values are
\code{"Chapman"}, \code{"Petersen"}, and \code{"Bailey"}.  Default to
\code{"Chapman"}.}

\item{useChapvar}{Whether to use the Chapman estimator variance instead of
the Petersen estimator variance for the normal-distribution interval, if
\code{"method"} is set to  \code{"Petersen"}. Defaults to \code{FALSE}.}
}
\value{
A list with the abundance estimate and confidence interval bounds for
  the normal-distribution and/or bootstrap confidence intervals.
}
\description{
Calculates approximate confidence intervals(s) for the
  Stratified estimator, using bootstrapping, the Normal approximation, or
  both.

  The bootstrap interval is created by resampling the data in the second
  sampling event, with replacement for each stratum; that is, drawing
  bootstrap values of m2 from a binomial distribution with probability
  parameter m2/n2.
}
\note{
Both the bootstrap and the normal approximation intervals make the
  naive assumption of independence between strata, which may not be the case.
  The user therefore cautioned, and is encouraged to investigate the coverage
  under relevant scenarios.
}
\examples{
cistrat(n1=c(100,200), n2=c(100,500), m2=c(10,10))
}
\seealso{
\\link{strattest}, \link{Nstrat}, \link{rstrat},  \link{vstrat}, \link{sestrat},
  \link{NChapman}, \link{NPetersen}, \link{NBailey}
}
\author{
Matt Tyers
}
