# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fills hexahedrons with a regular point raster (3D)
#'
#' @description
#' A hexahedron is a three dimensional shape that is defined by 6 faces and 8 corner points.
#' \code{fillhexa} allows to fill such a shape with a regular point raster.
#'
#' @details
#' See \url{https://stackoverflow.com/questions/36115215/filling-a-3d-body-with-a-systematic-point-raster}
#' for a description of the function and how it was developed.
#'
#' @param hex dataframe with three columns and eight rows to define a hexahedron by its corner
#' point coordinates x, y and z
#' @param res numeric value > 0 and <= 1 for the resolution of the point raster
#'
#' @return data.frame with the spatial coordinates of the resulting points of the grid
#'
#' @examples
#' hexatestdf <- data.frame(
#'   x = c(0,1,0,4,5,5,5,5),
#'   y = c(1,1,4,4,1,1,4,4),
#'   z = c(4,8,4,9,4,8,4,6)
#' )
#'
#' cx = fillhexa(hexatestdf, 0.1)
#'
#' #library(rgl)
#' #plot3d(
#' # cx[,1], cx[,2], cx[,3],
#' # type = "p",
#' # xlab = "x", ylab = "y", zlab = "z"
#' #)
#'
#' @export
fillhexa <- function(hex, res) {
    .Call('recexcavAAR_fillhexa', PACKAGE = 'recexcavAAR', hex, res)
}

#' Check if a point is within a polygon (2D)
#'
#' @description
#' \code{pnp} is able to determine if a point is within a polygon in 2D space.
#' The polygon is described by its corner points. The points must be in a correct
#' drawing order.
#'
#' Based on this solution:
#' Copyright (c) 1970-2003, Wm. Randolph Franklin
#' \url{https://www.ecse.rpi.edu/Homepages/wrf/Research/Short_Notes/pnpoly.html}
#'
#' @details
#' For discussion see: \url{http://stackoverflow.com/questions/217578/how-can-i-determine-whether-a-2d-point-is-within-a-polygon/2922778#2922778}
#'
#' @param vertx vector of x axis values of polygon corner points
#' @param verty vector of y axis values of polygon corner points
#' @param testx x axis value of point of interest
#' @param testy y axis value of point of interest
#'
#' @return boolean value - TRUE, if the point is within the polygon. Otherwise FALSE.
#'
#' @family pnpfuncs
#'
#' @examples
#' df <- data.frame(
#'   x = c(1,1,2,2),
#'   y = c(1,2,1,2)
#' )
#'
#' pnp(df$x, df$y, 1.5, 1.5)
#' pnp(df$x, df$y, 2.5, 2.5)
#'
#' # caution: false-negatives in edge-cases:
#' pnp(df$x, df$y, 2, 1.5)
#'
#' @export
pnp <- function(vertx, verty, testx, testy) {
    .Call('recexcavAAR_pnp', PACKAGE = 'recexcavAAR', vertx, verty, testx, testy)
}

#' Check if multiple points are within a polygon (2D)
#'
#' @description
#' \code{pnpmulti} works as \code{\link{pnp}} but for multiple points.
#'
#' @param vertx vector of x axis values of polygon corner points
#' @param verty vector of y axis values of polygon corner points
#' @param testx vector of x axis values of points of interest
#' @param testy vector of y axis values of points of interest
#'
#' @return vector with boolean values - TRUE, if the respective point is within the polygon.
#' Otherwise FALSE.
#'
#' @examples
#' polydf <- data.frame(
#'   x = c(1,1,2,2),
#'   y = c(1,2,1,2)
#' )
#'
#' testdf <- data.frame(
#'   x = c(1.5, 2.5),
#'   y = c(1.5, 2.5)
#' )
#'
#' pnpmulti(polydf$x, polydf$y, testdf$x, testdf$y)
#'
#' @family pnpfuncs
#'
#' @export
pnpmulti <- function(vertx, verty, testx, testy) {
    .Call('recexcavAAR_pnpmulti', PACKAGE = 'recexcavAAR', vertx, verty, testx, testy)
}

#' Multiple point position decision in relation to a set of stacked surfaces (3D)
#'
#' \code{posdec} has the purpose to make a decision about the position of individual points in relation
#' to a set of stacked surfaces in 3D space. The decision is made by comparing the mean z axis value of
#' the four horizontally closest points of a surface to the z axis value of the point in question.
#'
#' @param crdf data.frame with the spatial coordinates of the points of interest. Must contain three
#' columns with the x axis values, y axis values and z axis values of the points in the order x, y, z
#' @param maplist list of data.frames which contain the points that make up the surfaces. The individual
#' data.frames must have the same structure as \code{crdf}
#'
#' @return data.frame with the spatial coordinates of the points of interest and the respective position
#' information
#'
#' @family posdecfuncs
#'
#' @examples
#' df1 <- data.frame(
#'   x = rnorm(50),
#'   y = rnorm(50),
#'   z = rnorm(50) - 5
#' )
#'
#' df2 <- data.frame(
#'   x = rnorm(50),
#'   y = rnorm(50),
#'   z = rnorm(50) + 5
#')
#'
#' lpoints <- list(df1, df2)
#'
#' maps <- kriglist(lpoints, lags = 3, model = "spherical")
#'
#' finds <- data.frame(
#'   x = c(0, 1, 0.5, 0.7),
#'   y = c(0.5, 0, 1, 0.7),
#'   z = c(-10, 10, 0, 2)
#' )
#'
#' posdec(finds, maps)
#'
#' @export
posdec <- function(crdf, maplist) {
    .Call('recexcavAAR_posdec', PACKAGE = 'recexcavAAR', crdf, maplist)
}

#' Multiple point position decision in relation to a set of stacked surfaces (3D)
#' for multiple data.frames in a list
#'
#' \code{posdeclist} works as \code{\link{posdec}} but not just for a single data.frame
#' with individual points but for a list of data.frames
#'
#' @param crdflist list of data.frames with the spatial coordinates of the points of
#' interest (for details see \code{\link{posdec}})
#' @param maplist list of data.frames which contain the points that make up the surfaces
#'
#' @return list of data.frames with the spatial coordinates of the points of interest
#' and the respective position information
#'
#' @family posdecfuncs
#'
#' @examples
#' df1 <- data.frame(
#'   x = rnorm(50),
#'   y = rnorm(50),
#'   z = rnorm(50) - 5
#' )
#'
#' df2 <- data.frame(
#'   x = rnorm(50),
#'   y = rnorm(50),
#'   z = rnorm(50) + 5
#')
#'
#' lpoints <- list(df1, df2)
#'
#' maps <- kriglist(lpoints, lags = 3, model = "spherical")
#'
#' hexadf1 <- data.frame(
#'   x = c(0, 1, 0, 4, 5, 5, 5, 5),
#'   y = c(1, 1, 4, 4, 1, 1, 4, 4),
#'   z = c(1, 5, 1, 6, 1, 5, 1, 3)
#' )
#'
#' hexadf2 <- data.frame(
#'   x = c(0, 1, 0, 4, 5, 5, 5, 5),
#'   y = c(1, 1, 4, 4, 1, 1, 4, 4),
#'   z = c(-1, -5, -1, -6, -1, -5, -1, -3)
#' )
#'
#' cx1 <- fillhexa(hexadf1, 0.1)
#' cx2 <- fillhexa(hexadf2, 0.1)
#'
#' cubelist <- list(cx1, cx2)
#'
#' posdeclist(cubelist, maps)
#'
#' @export
posdeclist <- function(crdflist, maplist) {
    .Call('recexcavAAR_posdeclist', PACKAGE = 'recexcavAAR', crdflist, maplist)
}

#' Transformation of numeric matrices from wide to long format
#'
#' \code{spatiallong} transforms a set of two independent variables in vectors and a
#' dependent variable in a wide matrix to a long matrix that combines the information.
#' The result is exported as a data.frame.
#'
#' @param x vector of first independent variable. e.g. vector with x axis spatial points
#' @param y vector of second independent variable. e.g. vector with y axis spatial points
#' @param z matrix of dependent variable. e.g. matrix with z axis spatial points
#'
#' @return data.frame with three columns x, y and z
#'
#' @family transfuncs
#'
#' @examples
#' x <- c(1, 1, 1, 2, 2, 2, 3, 3, 4)
#' y <- c(1, 2, 3, 1, 2, 3, 1, 2, 3)
#' z <- c(3, 4, 2, 3, NA, 5, 6, 3, 1)
#'
#' sw <- spatialwide(x, y, z, digits = 3)
#'
#' spatiallong(sw$x, sw$y, sw$z)
#'
#' @export
spatiallong <- function(x, y, z) {
    .Call('recexcavAAR_spatiallong', PACKAGE = 'recexcavAAR', x, y, z)
}

#' Transformation of numeric matrices from long to wide format
#'
#' Transforms a set of two independent and one dependent variables in vectors from a long
#' to a wide format and exports this result as a list
#'
#' @param x vector of first independent variable. e.g. vector with x-axis spatial points
#' @param y vector of second independent variable. e.g. vector with y-axis spatial points
#' @param z vector of dependent variable. e.g. vector with z-axis spatial points
#' @param digits integer indicating the number of decimal places to be used for rounding
#' the dependent variables \code{x} and \code{y}.
#'
#' @return List with three elements:
#'
#' $x: vector with ascendingly sorted, unique values of the first independent variable \code{x}
#'
#' $y: vector with ascendingly sorted, unique values of the second independent variable \code{y}
#'
#' $z: matrix with the values of z for the defined combinations of \code{x} (columns) and
#' \code{y} (rows)
#'
#' @family transfuncs
#'
#' @examples
#' x <- c(1, 1, 1, 2, 2, 2, 3, 3, 4)
#' y <- c(1, 2, 3, 1, 2, 3, 1, 2, 3)
#' z <- c(3, 4, 2, 3, NA, 5, 6, 3, 1)
#'
#' spatialwide(x, y, z, digits = 3)
#'
#' @export
spatialwide <- function(x, y, z, digits) {
    .Call('recexcavAAR_spatialwide', PACKAGE = 'recexcavAAR', x, y, z, digits)
}

#' Center determination for hexahedrons
#'
#' A hexahedron is a three dimensional shape that is defined by 6 faces and 8 corner points.
#' \code{spitcenter} determines a center point for an input hexahedron by calculating the mean
#' of the maximal extent on all three axis.
#'
#' @param hex dataframe with three columns and eight rows to define a hexahedron by its corner
#' point coordinates x, y and z
#'
#' @return vector with the spatial coordinates of the center point of the input hexahedron
#'
#' @family centerdetfuncs
#'
#' @examples
#' hexatestdf <- data.frame(
#'   x = c(0,1,0,4,5,5,5,5),
#'   y = c(1,1,4,4,1,1,4,4),
#'   z = c(4,8,4,9,4,8,4,6)
#' )
#'
#' center <- spitcenter(hexatestdf)
#'
#' #library(rgl)
#' #plot3d(
#' # hexatestdf$x, hexatestdf$y, hexatestdf$z,
#' # type = "p",
#' # xlab = "x", ylab = "y", zlab = "z"
#' #)
#' #plot3d(
#' #  center[1], center[2], center[3],
#' #  type = "p",
#' #  col = "red",
#' #  add = TRUE
#' #)
#'
#' @export
spitcenter <- function(hex) {
    .Call('recexcavAAR_spitcenter', PACKAGE = 'recexcavAAR', hex)
}

#' Center determination for rectangles whose tops and bottoms are defined by irregular surfaces (3D)
#'
#' \code{spitcenternat} first of all calculates the horizontal center of an input rectangle.
#' Then it determines the vertical positions of the center points in relation to a surface stack.
#'
#' @param hex data.frame with the 2D corners of the rectangle defined by four points
#' @param maplist list of data.frames which contain the points that make up the surfaces
#'
#' @return data.frame with the spatial coordinates of the center points
#'
#' @family centerdetfuncs
#'
#' @examples
#' df1 <- data.frame(
#'   x = c(rep(0, 6), seq(0.2, 2.8, 0.2), seq(0.2, 2.8, 0.2), rep(3,6)),
#'   y = c(seq(0, 1, 0.2), rep(0, 14), rep(1, 14), seq(0, 1, 0.2)),
#'   z = c(0.9+0.05*rnorm(6), 0.9+0.05*rnorm(14), 1.3+0.05*rnorm(14), 1.2+0.05*rnorm(6))
#' )
#'
#' df2 <- data.frame(
#'     x = c(rep(0, 6), seq(0.2, 2.8, 0.2), seq(0.2, 2.8, 0.2), rep(3,6)),
#'     y = c(seq(0, 1, 0.2), rep(0, 14), rep(1, 14), seq(0, 1, 0.2)),
#'     z = c(0.6+0.05*rnorm(6), 0.6+0.05*rnorm(14), 1.0+0.05*rnorm(14), 0.9+0.05*rnorm(6))
#' )
#'
#' df3 <- data.frame(
#'     x = c(rep(0, 6), seq(0.2, 2.8, 0.2), seq(0.2, 2.8, 0.2), rep(3,6)),
#'     y = c(seq(0, 1, 0.2), rep(0, 14), rep(1, 14), seq(0, 1, 0.2)),
#'     z = c(0.3+0.05*rnorm(6), 0.3+0.05*rnorm(14), 0.7+0.05*rnorm(14), 0.6+0.05*rnorm(6))
#' )
#'
#' lpoints <- list(df1, df2, df3)
#'
#' maps <- kriglist(lpoints, lags = 3, model = "spherical")
#'
#' hexatestdf <- data.frame(
#'     x = c(1, 1, 1, 1, 2, 2, 2, 2),
#'     y = c(0, 1, 0, 1, 0, 1, 0, 1)
#' )
#'
#' spitcenternat(hexatestdf, maps)
#'
#' @export
spitcenternat <- function(hex, maplist) {
    .Call('recexcavAAR_spitcenternat', PACKAGE = 'recexcavAAR', hex, maplist)
}

#' Center determination for rectangles whose tops and bottoms are defined by irregular
#' surfaces (3D) for multiple data.frames in a list
#'
#' \code{spitcenternatlist} works as \code{\link{spitcenternat}} but not just for a
#' single data.frame but for a list of data.frames
#'
#' @param hexlist list of data.frames with the 2D corners of the rectangles
#' @param maplist list of data.frames which contain the points that make up the surfaces
#'
#' @return list of data.frames with the spatial coordinates of the center points
#'
#' @family centerdetfuncs
#'
#' @examples
#' df1 <- data.frame(
#' x = c(rep(0, 6), seq(0.2, 2.8, 0.2), seq(0.2, 2.8, 0.2), rep(3,6)),
#'   y = c(seq(0, 1, 0.2), rep(0, 14), rep(1, 14), seq(0, 1, 0.2)),
#'   z = c(0.9+0.05*rnorm(6), 0.9+0.05*rnorm(14), 1.3+0.05*rnorm(14), 1.2+0.05*rnorm(6))
#' )
#'
#' df2 <- data.frame(
#'     x = c(rep(0, 6), seq(0.2, 2.8, 0.2), seq(0.2, 2.8, 0.2), rep(3,6)),
#'     y = c(seq(0, 1, 0.2), rep(0, 14), rep(1, 14), seq(0, 1, 0.2)),
#'     z = c(0.6+0.05*rnorm(6), 0.6+0.05*rnorm(14), 1.0+0.05*rnorm(14), 0.9+0.05*rnorm(6))
#' )
#'
#' df3 <- data.frame(
#'     x = c(rep(0, 6), seq(0.2, 2.8, 0.2), seq(0.2, 2.8, 0.2), rep(3,6)),
#'     y = c(seq(0, 1, 0.2), rep(0, 14), rep(1, 14), seq(0, 1, 0.2)),
#'     z = c(0.3+0.05*rnorm(6), 0.3+0.05*rnorm(14), 0.7+0.05*rnorm(14), 0.6+0.05*rnorm(6))
#' )
#'
#' lpoints <- list(df1, df2, df3)
#'
#' maps <- kriglist(lpoints, lags = 3, model = "spherical")
#'
#' hexatestdf1 <- data.frame(
#'   x = c(1, 1, 1, 1, 2, 2, 2, 2),
#'   y = c(0, 1, 0, 1, 0, 1, 0, 1)
#' )
#'
#' hexatestdf2 <- data.frame(
#'   x = c(0, 0, 0, 0, 1, 1, 1, 1),
#'   y = c(0, 1, 0, 1, 0, 1, 0, 1)
#' )
#'
#' hexs <- list(hexatestdf1, hexatestdf2)
#'
#' spitcenternatlist(hexs, maps)
#'
#' @export
spitcenternatlist <- function(hexlist, maplist) {
    .Call('recexcavAAR_spitcenternatlist', PACKAGE = 'recexcavAAR', hexlist, maplist)
}

